/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

public class XAttrLock
extends Lock {
    private static int bacthLockSize = 1000;
    private final List<XAttr> attrs;
    private final String path;

    protected static void setBacthLockSize(int bacthLockSize) {
        XAttrLock.bacthLockSize = bacthLockSize;
    }

    public XAttrLock(List<XAttr> attrs) {
        this(attrs, null);
    }

    public XAttrLock(List<XAttr> attrs, String path) {
        this.attrs = attrs;
        this.path = path;
    }

    public XAttrLock(XAttr attr) {
        this(attr, null);
    }

    public XAttrLock(XAttr attr, String path) {
        if (attr != null) {
            this.attrs = new ArrayList<XAttr>();
            this.attrs.add(attr);
        } else {
            this.attrs = null;
        }
        this.path = path;
    }

    public XAttrLock() {
        this.attrs = null;
        this.path = null;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        boolean canBatchLock;
        BaseINodeLock inodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
        boolean bl = canBatchLock = this.attrs != null && !this.attrs.isEmpty();
        if (canBatchLock) {
            this.batchLockInodes(inodeLock.getTargetINodes());
        } else {
            for (INode inode : inodeLock.getTargetINodes()) {
                this.scanLock(inode);
            }
        }
        if (this.path != null) {
            if (canBatchLock) {
                this.batchLockInodes(inodeLock.getChildINodes(this.path));
            } else {
                for (INode inode : inodeLock.getChildINodes(this.path)) {
                    this.scanLock(inode);
                }
            }
        }
    }

    private void batchLockInodes(List<INode> inodes) throws TransactionContextException, StorageException {
        ArrayList<StoredXAttr.PrimaryKey> allAttr = new ArrayList<StoredXAttr.PrimaryKey>(inodes.size());
        for (INode inode : inodes) {
            if (!inode.hasXAttrs()) {
                EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.NoXAttrsAttached, (Object[])new Object[]{inode.getId()});
                continue;
            }
            List<StoredXAttr.PrimaryKey> inodeXAttrLocks = XAttrFeature.getPrimaryKeys(inode.getId(), this.attrs);
            allAttr.addAll(inodeXAttrLocks);
        }
        this.batchLockInternal(allAttr);
    }

    private void batchLockInternal(List<StoredXAttr.PrimaryKey> allAttr) throws TransactionContextException, StorageException {
        int numOfSlices = allAttr.size() <= bacthLockSize ? 1 : (int)Math.ceil((double)allAttr.size() / (double)bacthLockSize);
        for (int slice = 0; slice < numOfSlices; ++slice) {
            int startIndex = slice * bacthLockSize;
            int endIndex = Math.min((slice + 1) * bacthLockSize, allAttr.size());
            List<StoredXAttr.PrimaryKey> subList = allAttr.subList(startIndex, endIndex);
            this.acquireLockList(DEFAULT_LOCK_TYPE, (FinderType)StoredXAttr.Finder.ByPrimaryKeyBatch, new Object[]{subList});
        }
    }

    private void scanLock(INode inode) throws TransactionContextException, StorageException {
        assert (this.attrs == null || this.attrs.isEmpty());
        if (!inode.hasXAttrs()) {
            EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.NoXAttrsAttached, (Object[])new Object[]{inode.getId()});
        } else {
            this.acquireLockList(DEFAULT_LOCK_TYPE, (FinderType)StoredXAttr.Finder.ByInodeId, new Object[]{inode.getId()});
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.XAttr;
    }
}

