/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher.testservices;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.launcher.AbstractLaunchableService;
import org.apache.hadoop.service.launcher.ServiceLaunchException;
import org.apache.hadoop.util.ExitCodeProvider;

public class ExceptionInExecuteLaunchableService
extends AbstractLaunchableService {
    public static final String NAME = "org.apache.hadoop.service.launcher.testservices.ExceptionInExecuteLaunchableService";
    public static final String ARG_THROW_SLE = "--SLE";
    public static final String ARG_THROW_IOE = "--IOE";
    public static final String ARG_THROWABLE = "--throwable";
    public static final String SLE_TEXT = "SLE raised in execute()";
    public static final String OTHER_EXCEPTION_TEXT = "Other exception";
    public static final String EXIT_IN_IOE_TEXT = "Exit in IOE";
    public static final int IOE_EXIT_CODE = 64;
    private ExType exceptionType = ExType.EX;

    public ExceptionInExecuteLaunchableService() {
        super("ExceptionInExecuteLaunchedService");
    }

    public Configuration bindArgs(Configuration config, List<String> args) throws Exception {
        if (args.contains(ARG_THROW_SLE)) {
            this.exceptionType = ExType.SLE;
        } else if (args.contains(ARG_THROW_IOE)) {
            this.exceptionType = ExType.IOE;
        } else if (args.contains(ARG_THROWABLE)) {
            this.exceptionType = ExType.THROWABLE;
        }
        return super.bindArgs(config, args);
    }

    public int execute() throws Exception {
        switch (this.exceptionType) {
            case SLE: {
                throw new ServiceLaunchException(5, SLE_TEXT);
            }
            case IOE: {
                throw new IOECodedException();
            }
            case THROWABLE: {
                throw new OutOfMemoryError("OOM");
            }
        }
        throw new Exception(OTHER_EXCEPTION_TEXT);
    }

    public static class IOECodedException
    extends IOException
    implements ExitCodeProvider {
        public IOECodedException() {
            super(ExceptionInExecuteLaunchableService.EXIT_IN_IOE_TEXT);
        }

        public int getExitCode() {
            return 64;
        }
    }

    static enum ExType {
        EX,
        SLE,
        IOE,
        THROWABLE;

    }
}

