/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.BlockLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

public class LastBlockReplicasHashBucketLock
extends Lock {
    protected void acquire(TransactionLocks locks) throws IOException {
        BlockLock blockLock = (BlockLock)locks.getLock(Lock.Type.Block);
        for (INodeFile iNodeFile : blockLock.getFiles()) {
            List replicas;
            BlockInfoContiguous lastBlock = iNodeFile.getLastBlock();
            if (iNodeFile.getLastBlock() == null || (replicas = (List)EntityManager.findList((FinderType)Replica.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{lastBlock.getBlockId(), iNodeFile.getId()})) == null) continue;
            Collections.sort(replicas, new Comparator<Replica>(){

                @Override
                public int compare(Replica o1, Replica o2) {
                    return new Integer(o1.getBucketId()).compareTo(o2.getBucketId());
                }
            });
            for (Replica replica : replicas) {
                EntityManager.find((FinderType)HashBucket.Finder.ByStorageIdAndBucketId, (Object[])new Object[]{replica.getStorageId(), replica.getBucketId()});
            }
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.HashBucket;
    }
}

