/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.types;

import com.google.common.base.Preconditions;
import io.hops.hadoop.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hadoop.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.registry.client.binding.JsonSerDeser;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Endpoint
implements Cloneable {
    public String api;
    public String addressType;
    public String protocolType;
    public List<Map<String, String>> addresses;
    private static final Marshal marshalToString = new Marshal();

    public Endpoint() {
    }

    public Endpoint(Endpoint that) {
        this.api = that.api;
        this.addressType = that.addressType;
        this.protocolType = that.protocolType;
        this.addresses = this.newAddresses(that.addresses.size());
        for (Map<String, String> address : that.addresses) {
            HashMap<String, String> addr2 = new HashMap<String, String>(address.size());
            addr2.putAll(address);
            this.addresses.add(addr2);
        }
    }

    public Endpoint(String api, String addressType, String protocolType, List<Map<String, String>> addrs) {
        this.api = api;
        this.addressType = addressType;
        this.protocolType = protocolType;
        this.addresses = this.newAddresses(0);
        if (addrs != null) {
            this.addresses.addAll(addrs);
        }
    }

    public Endpoint(String api, String addressType, String protocolType) {
        this.api = api;
        this.addressType = addressType;
        this.protocolType = protocolType;
        this.addresses = this.newAddresses(0);
    }

    public Endpoint(String api, String addressType, String protocolType, Map<String, String> addr) {
        this(api, addressType, protocolType);
        if (addr != null) {
            this.addresses.add(addr);
        }
    }

    public Endpoint(String api, String addressType, String protocolType, Map<String, String> ... addrs) {
        this(api, addressType, protocolType);
        for (Map<String, String> addr : addrs) {
            if (addr == null) continue;
            this.addresses.add(addr);
        }
    }

    private List<Map<String, String>> newAddresses(int size) {
        return new ArrayList<Map<String, String>>(size);
    }

    public Endpoint(String api, String protocolType, URI ... uris) {
        this.api = api;
        this.addressType = "uri";
        this.protocolType = protocolType;
        List<Map<String, String>> addrs = this.newAddresses(uris.length);
        for (URI uri : uris) {
            addrs.add(RegistryTypeUtils.uri(uri.toString()));
        }
        this.addresses = addrs;
    }

    public String toString() {
        return marshalToString.toString(this);
    }

    public void validate() {
        Preconditions.checkNotNull((Object)this.api, (Object)"null API field");
        Preconditions.checkNotNull((Object)this.addressType, (Object)"null addressType field");
        Preconditions.checkNotNull((Object)this.protocolType, (Object)"null protocolType field");
        Preconditions.checkNotNull(this.addresses, (Object)"null addresses field");
        for (Map<String, String> address : this.addresses) {
            Preconditions.checkNotNull(address, (Object)"null element in address");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class Marshal
    extends JsonSerDeser<Endpoint> {
        private Marshal() {
            super(Endpoint.class);
        }
    }
}

