/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.zaxxer.hikari.hibernate;

import io.hops.hadoop.shaded.com.zaxxer.hikari.HikariConfig;
import io.hops.hadoop.shaded.com.zaxxer.hikari.HikariDataSource;
import io.hops.hadoop.shaded.com.zaxxer.hikari.hibernate.HikariConfigurationUtil;
import io.hops.hadoop.shaded.org.hibernate.HibernateException;
import io.hops.hadoop.shaded.org.hibernate.Version;
import io.hops.hadoop.shaded.org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import io.hops.hadoop.shaded.org.hibernate.service.UnknownUnwrapTypeException;
import io.hops.hadoop.shaded.org.hibernate.service.spi.Configurable;
import io.hops.hadoop.shaded.org.hibernate.service.spi.Stoppable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -9131625057941275711L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariConnectionProvider.class);
    private HikariConfig hcfg = null;
    private HikariDataSource hds = null;

    public HikariConnectionProvider() {
        if (Version.getVersionString().substring(0, 5).compareTo("4.3.6") >= 1) {
            LOGGER.warn("io.hops.hadoop.shaded.com.zaxxer.hikari.hibernate.HikariConnectionProvider has been deprecated for versions of Hibernate 4.3.6 and newer.  Please switch to org.hibernate.hikaricp.internal.HikariCPConnectionProvider.");
        }
    }

    public void configure(Map props) throws HibernateException {
        try {
            LOGGER.debug("Configuring HikariCP");
            this.hcfg = HikariConfigurationUtil.loadConfiguration(props);
            this.hds = new HikariDataSource(this.hcfg);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
        LOGGER.debug("HikariCP Configured");
    }

    public Connection getConnection() throws SQLException {
        Connection conn = null;
        if (this.hds != null) {
            conn = this.hds.getConnection();
        }
        return conn;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || HikariConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || HikariConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.hds;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        this.hds.close();
    }
}

