/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.io.netty.buffer.ByteBufAllocator;
import io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxnSocketNIO;
import io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxnSocketNetty;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.ZKClientConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.TestByteBufAllocator;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientCnxnSocketTest {
    @Before
    public void setUp() {
        ClientCnxnSocketNetty.setTestAllocator((ByteBufAllocator)TestByteBufAllocator.getInstance());
    }

    @After
    public void tearDown() {
        ClientCnxnSocketNetty.clearTestAllocator();
        TestByteBufAllocator.checkForLeaks();
    }

    @Test
    public void testWhenInvalidJuteMaxBufferIsConfiguredIOExceptionIsThrown() {
        ZKClientConfig clientConfig = new ZKClientConfig();
        String value = "SomeInvalidInt";
        clientConfig.setProperty("jute.maxbuffer", value);
        try {
            new ClientCnxnSocketNIO(clientConfig);
            Assert.fail((String)"IOException is expected.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(value));
        }
        try {
            new ClientCnxnSocketNetty(clientConfig);
            Assert.fail((String)"IOException is expected.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(value));
        }
    }
}

