/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ExitCode;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrityCheck
implements AsyncCallback.StatCallback,
AsyncCallback.DataCallback {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrityCheck.class);
    ZooKeeper zk;
    Map<String, byte[]> lastValue = new HashMap<String, byte[]>();
    int count;
    String path;
    int iteration;
    int outstanding;
    int errorCount;

    synchronized void incOutstanding() {
        ++this.outstanding;
    }

    synchronized void decOutstanding() {
        --this.outstanding;
        this.notifyAll();
    }

    synchronized void waitOutstanding() throws InterruptedException {
        while (this.outstanding > 0) {
            this.wait();
        }
    }

    IntegrityCheck(String hostPort, String path, int count) throws Exception {
        this.zk = ClientBase.createZKClient(hostPort);
        this.path = path;
        this.count = count;
    }

    public void run() throws InterruptedException, KeeperException {
        try {
            LOG.warn("Creating znodes for {}", (Object)this.path);
            this.doCreate();
            LOG.warn("Staring the test loop for {}", (Object)this.path);
            while (true) {
                LOG.warn("Staring write cycle for {}", (Object)this.path);
                this.doPopulate();
                this.waitOutstanding();
                LOG.warn("Staring read cycle for {}", (Object)this.path);
                this.readAll();
                this.waitOutstanding();
            }
        }
        catch (Throwable throwable) {
            LOG.warn("Test loop terminated for {}", (Object)this.path);
            throw throwable;
        }
    }

    void readAll() {
        for (int i = 0; i < this.count; ++i) {
            String cpath = this.path + "/" + i;
            this.zk.getData(cpath, false, (AsyncCallback.DataCallback)this, null);
            this.incOutstanding();
        }
    }

    void doCreate() throws InterruptedException, KeeperException {
        try {
            this.zk.create(this.path, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        ++this.iteration;
        byte[] v = ("" + this.iteration).getBytes();
        for (int i = 0; i < this.count; ++i) {
            String cpath = this.path + "/" + i;
            try {
                if (i % 10 == 0) {
                    LOG.warn("Creating znode {}", (Object)cpath);
                }
                this.zk.create(cpath, v, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            this.lastValue.put(cpath, v);
        }
    }

    void doPopulate() {
        ++this.iteration;
        byte[] v = ("" + this.iteration).getBytes();
        for (int i = 0; i < this.count; ++i) {
            String cpath = this.path + "/" + i;
            this.zk.setData(cpath, v, -1, this, v);
            this.incOutstanding();
        }
    }

    synchronized void ensureConnected() {
        while (this.zk.getState() != ZooKeeper.States.CONNECTED) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("USAGE: IntegrityCheck zookeeperHostPort znode #children");
            return;
        }
        int childrenCount = 0;
        try {
            childrenCount = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.exit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        try {
            final IntegrityCheck ctest = new IntegrityCheck(args[0], args[1], childrenCount);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.out.println(new Date().toString() + ": Error count = " + ctest.errorCount);
                }
            });
            while (true) {
                try {
                    while (true) {
                        ctest.ensureConnected();
                        ctest.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(ExitCode.INVALID_INVOCATION.getValue());
            return;
        }
    }

    @Override
    public void processResult(int rc, String path, Object ctx, Stat stat) {
        if (rc == 0) {
            this.lastValue.put(path, (byte[])ctx);
        }
        this.decOutstanding();
    }

    @Override
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        if (rc == 0) {
            String string = new String(data);
            String lastString = null;
            byte[] v = this.lastValue.get(path);
            if (v != null) {
                lastString = new String(v);
            }
            if (lastString != null && Integer.parseInt(string) < Integer.parseInt(lastString)) {
                LOG.error("ERROR: Got {} expected >= {}", (Object)string, (Object)lastString);
                ++this.errorCount;
            }
            this.lastValue.put(path, (byte[])ctx);
        }
        this.decOutstanding();
    }
}

