/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.ClientX509Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.KerberosTestUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.MiniKdc;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.SaslTestUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SaslKerberosAuthOverSSLTest
extends ClientBase {
    private ClientX509Util clientX509Util;
    private File keytabFileForKerberosPrincipals;
    private File saslConfFile;
    private static MiniKdc kdc;
    private static File kdcWorkDir;
    private static Properties conf;

    @BeforeClass
    public static void setupKdc() {
        SaslKerberosAuthOverSSLTest.startMiniKdc();
    }

    @AfterClass
    public static void tearDownKdc() {
        SaslKerberosAuthOverSSLTest.stopMiniKdc();
        FileUtils.deleteQuietly((File)kdcWorkDir);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.initSaslConfig();
        this.clientX509Util = this.setUpSSLWithNoAuth();
        String host = "localhost";
        int port = PortAssignment.unique();
        this.hostPort = host + ":" + port;
        this.serverFactory = ServerCnxnFactory.createFactory();
        this.serverFactory.configure(new InetSocketAddress(host, port), this.maxCnxns, -1, true);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.clearSslSetting(this.clientX509Util);
        this.clearSaslConfig();
    }

    @Test
    public void testAuth() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Thread.sleep(1000L);
        }
    }

    public void initSaslConfig() throws Exception {
        this.keytabFileForKerberosPrincipals = new File(KerberosTestUtils.getKeytabFile());
        String clientPrincipal = KerberosTestUtils.getClientPrincipal();
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        clientPrincipal = clientPrincipal.substring(0, clientPrincipal.lastIndexOf("@"));
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        kdc.createPrincipal(this.keytabFileForKerberosPrincipals, clientPrincipal, serverPrincipal);
        System.setProperty("zookeeper.server.principal", KerberosTestUtils.getServerPrincipal());
        System.setProperty("zookeeper.sasl.client", "true");
        System.setProperty("zookeeper.server.realm", KerberosTestUtils.getRealm());
        System.setProperty("zookeeper.sasl.clientconfig", "ClientUsingKerberos");
        System.setProperty("zookeeper.authProvider.1", "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty(SaslTestUtil.requireSASLAuthProperty, "true");
        try {
            File tmpDir = SaslKerberosAuthOverSSLTest.createTmpDir();
            this.saslConfFile = new File(tmpDir, "jaas.conf");
            PrintWriter saslConf = new PrintWriter(new FileWriter(this.saslConfFile));
            saslConf.println("Server {");
            saslConf.println("  com.sun.security.auth.module.Krb5LoginModule required");
            saslConf.println("  storeKey=\"true\"");
            saslConf.println("  useTicketCache=\"false\"");
            saslConf.println("  useKeyTab=\"true\"");
            saslConf.println("  doNotPrompt=\"true\"");
            saslConf.println("  debug=\"true\"");
            saslConf.println("  refreshKrb5Config=\"true\"");
            saslConf.println("  keyTab=\"" + this.keytabFileForKerberosPrincipals.getAbsolutePath() + "\"");
            saslConf.println("  principal=\"" + KerberosTestUtils.getServerPrincipal() + "\";");
            saslConf.println("};");
            saslConf.println("ClientUsingKerberos {");
            saslConf.println("  com.sun.security.auth.module.Krb5LoginModule required");
            saslConf.println("  storeKey=\"false\"");
            saslConf.println("  useTicketCache=\"false\"");
            saslConf.println("  useKeyTab=\"true\"");
            saslConf.println("  doNotPrompt=\"true\"");
            saslConf.println("  debug=\"true\"");
            saslConf.println("  refreshKrb5Config=\"true\"");
            saslConf.println("  keyTab=\"" + this.keytabFileForKerberosPrincipals.getAbsolutePath() + "\"");
            saslConf.println("  principal=\"" + KerberosTestUtils.getClientPrincipal() + "\";");
            saslConf.println("};");
            saslConf.close();
            System.setProperty("java.security.auth.login.config", this.saslConfFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.error("could not create tmp directory to hold JAAS conf file, test will fail...", (Throwable)e);
        }
        Configuration.getConfiguration().refresh();
    }

    public void clearSaslConfig() {
        FileUtils.deleteQuietly((File)this.keytabFileForKerberosPrincipals);
        FileUtils.deleteQuietly((File)this.saslConfFile);
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("zookeeper.sasl.client.username");
        System.clearProperty("zookeeper.sasl.client");
        System.clearProperty("zookeeper.sasl.clientconfig");
        System.clearProperty("zookeeper.authProvider.1");
        System.clearProperty(SaslTestUtil.requireSASLAuthProperty);
        System.clearProperty("zookeeper.server.principal");
    }

    public ClientX509Util setUpSSLWithNoAuth() {
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty("zookeeper.serverCnxnFactory", "io.hops.hadoop.shaded.org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty("zookeeper.ssl.clientAuth", "none");
        System.setProperty("zookeeper.ssl.quorum.clientAuth", "none");
        ClientX509Util x509Util = new ClientX509Util();
        System.setProperty(x509Util.getSslTruststoreLocationProperty(), testDataPath + "/ssl/testTrustStore.jks");
        System.setProperty(x509Util.getSslTruststorePasswdProperty(), "testpass");
        System.setProperty(x509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(x509Util.getSslKeystorePasswdProperty(), "testpass");
        return x509Util;
    }

    public void clearSslSetting(ClientX509Util clientX509Util) {
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty(clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(clientX509Util.getSslTruststorePasswdProperty());
        System.clearProperty(clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty("javax.net.debug");
        System.clearProperty("zookeeper.ssl.clientAuth");
        System.clearProperty("zookeeper.ssl.quorum.clientAuth");
        clientX509Util.close();
    }

    public static void startMiniKdc() {
        try {
            kdcWorkDir = SaslKerberosAuthOverSSLTest.createEmptyTestDir();
            conf = MiniKdc.createConf();
            conf.setProperty("debug", "true");
            kdc = new MiniKdc(conf, kdcWorkDir);
            kdc.start();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to start MiniKdc", e);
        }
    }

    public static void stopMiniKdc() {
        if (kdc != null) {
            kdc.stop();
        }
    }
}

