/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerStats;
import io.hops.hadoop.shaded.org.hamcrest.MatcherAssert;
import io.hops.hadoop.shaded.org.hamcrest.Matchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerStatsTest
extends ZKTestCase {
    private ServerStats.Provider providerMock;

    @Before
    public void setUp() {
        this.providerMock = Mockito.mock(ServerStats.Provider.class);
    }

    @Test
    public void testPacketsMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        int incrementCount = 20;
        for (int i = 0; i < incrementCount; ++i) {
            serverStats.incrementPacketsSent();
            serverStats.incrementPacketsReceived();
            serverStats.incrementPacketsReceived();
        }
        Assert.assertEquals((long)incrementCount, (long)serverStats.getPacketsSent());
        Assert.assertEquals((long)(incrementCount * 2), (long)serverStats.getPacketsReceived());
        serverStats.resetRequestCounters();
        this.assertAllPacketsZero(serverStats);
    }

    @Test
    public void testLatencyMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        Request fakeRequest = new Request(0L, 0, 0, null, null, 0L);
        serverStats.updateLatency(fakeRequest, fakeRequest.createTime + 1000L);
        serverStats.updateLatency(fakeRequest, fakeRequest.createTime + 2000L);
        MatcherAssert.assertThat("Max latency check", 2000L, Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(serverStats.getMaxLatency())));
        MatcherAssert.assertThat("Min latency check", 1000L, Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(serverStats.getMinLatency())));
        Assert.assertEquals((double)1500.0, (double)serverStats.getAvgLatency(), (double)200.0);
        serverStats.resetLatency();
        this.assertAllLatencyZero(serverStats);
    }

    @Test
    public void testFsyncThresholdExceedMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        int incrementCount = 30;
        for (int i = 0; i < incrementCount; ++i) {
            serverStats.incrementFsyncThresholdExceedCount();
        }
        Assert.assertEquals((long)incrementCount, (long)serverStats.getFsyncThresholdExceedCount());
        serverStats.resetFsyncThresholdExceedCount();
        this.assertFsyncThresholdExceedCountZero(serverStats);
    }

    @Test
    public void testReset() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        this.assertAllPacketsZero(serverStats);
        this.assertAllLatencyZero(serverStats);
        Request fakeRequest = new Request(0L, 0, 0, null, null, 0L);
        serverStats.incrementPacketsSent();
        serverStats.incrementPacketsReceived();
        serverStats.updateLatency(fakeRequest, fakeRequest.createTime + 1000L);
        serverStats.reset();
        this.assertAllPacketsZero(serverStats);
        this.assertAllLatencyZero(serverStats);
    }

    private void assertAllPacketsZero(ServerStats serverStats) {
        Assert.assertEquals((long)0L, (long)serverStats.getPacketsSent());
        Assert.assertEquals((long)0L, (long)serverStats.getPacketsReceived());
    }

    private void assertAllLatencyZero(ServerStats serverStats) {
        Assert.assertEquals((long)0L, (long)serverStats.getMaxLatency());
        Assert.assertEquals((long)0L, (long)serverStats.getMinLatency());
        Assert.assertEquals((double)0.0, (double)serverStats.getAvgLatency(), (double)1.0E-5);
    }

    private void assertFsyncThresholdExceedCountZero(ServerStats serverStats) {
        Assert.assertEquals((long)0L, (long)serverStats.getFsyncThresholdExceedCount());
    }
}

