/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentEpochWriteFailureTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(CurrentEpochWriteFailureTest.class);
    private QuorumPeerTestBase.Servers servers;
    private int clientPort;

    @Override
    @After
    public void tearDown() throws InterruptedException {
        if (this.servers != null) {
            this.servers.shutDownAllServers();
        }
    }

    @Test
    public void testReadCurrentEpochFromAcceptedEpochTmpFile() throws Exception {
        this.startServers();
        this.writeSomeData();
        this.restartServers();
        this.writeSomeData();
        QuorumPeerTestBase.MainThread firstServer = this.servers.mt[0];
        long currentEpoch = firstServer.getQuorumPeer().getCurrentEpoch();
        Assert.assertEquals((long)2L, (long)currentEpoch);
        File snapDir = firstServer.getQuorumPeer().getTxnFactory().getSnapDir();
        File currentEpochFile = new File(snapDir, "currentEpoch");
        File currentEpochTempFile = new File(snapDir, "currentEpoch.tmp");
        this.servers.shutDownAllServers();
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTING);
        FileUtils.write((File)currentEpochFile, (CharSequence)Long.toString(currentEpoch - 1L), (String)"UTF-8");
        FileUtils.write((File)currentEpochTempFile, (CharSequence)Long.toString(currentEpoch), (String)"UTF-8");
        this.servers.restartAllServersAndClients(this);
        Assert.assertTrue((String)("server " + firstServer.getMyid() + " is not up as file currentEpoch.tmp rename to currentEpoch file was failed which lead current epoch inconsistent state."), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + firstServer.getClientPort(), ClientBase.CONNECTION_TIMEOUT));
    }

    private void restartServers() throws InterruptedException, IOException {
        this.servers.shutDownAllServers();
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTING);
        this.servers.restartAllServersAndClients(this);
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTED);
    }

    private void writeSomeData() throws Exception {
        ZooKeeper client = ClientBase.createZKClient("127.0.0.1:" + this.clientPort);
        String path = "/somePath" + System.currentTimeMillis();
        String data = "someData";
        client.create(path, data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] data1 = client.getData(path, false, null);
        Assert.assertEquals((Object)data, (Object)new String(data1));
        client.close();
    }

    private void startServers() throws Exception {
        this.servers = this.LaunchServers(3);
        this.clientPort = this.servers.clientPorts[0];
    }
}

