/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.adaptor;

import io.hops.exception.StorageException;
import io.hops.metadata.DalAdaptor;
import io.hops.metadata.hdfs.dal.CachePoolDataAccess;
import io.hops.metadata.hdfs.entity.CachePool;
import java.util.Collection;
import org.apache.hadoop.fs.permission.FsPermission;

public class CachePoolDALAdaptor
extends DalAdaptor<org.apache.hadoop.hdfs.server.namenode.CachePool, CachePool>
implements CachePoolDataAccess<org.apache.hadoop.hdfs.server.namenode.CachePool> {
    private CachePoolDataAccess<CachePool> dataAccess;

    public CachePoolDALAdaptor(CachePoolDataAccess<CachePool> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public CachePool convertHDFStoDAL(org.apache.hadoop.hdfs.server.namenode.CachePool cachePool) throws StorageException {
        return new CachePool(cachePool.getPoolName(), cachePool.getOwnerName(), cachePool.getGroupName(), cachePool.getMode().toShort(), cachePool.getLimit(), cachePool.getMaxRelativeExpiryMs(), cachePool.getBytesNeeded(), cachePool.getBytesCached(), cachePool.getFilesNeeded(), cachePool.getFilesCached());
    }

    public org.apache.hadoop.hdfs.server.namenode.CachePool convertDALtoHDFS(CachePool cachePool) {
        if (cachePool == null) {
            return null;
        }
        return new org.apache.hadoop.hdfs.server.namenode.CachePool(cachePool.getPoolName(), cachePool.getOwnerName(), cachePool.getGroupName(), new FsPermission(cachePool.getMode()), cachePool.getLimit(), cachePool.getMaxRelativeExpiryMs(), cachePool.getBytesNeeded(), cachePool.getBytesCached(), cachePool.getFilesNeeded(), cachePool.getFilesCached());
    }

    public void prepare(Collection<org.apache.hadoop.hdfs.server.namenode.CachePool> removed, Collection<org.apache.hadoop.hdfs.server.namenode.CachePool> newed) throws StorageException {
        this.dataAccess.prepare(this.convertHDFStoDAL(removed), this.convertHDFStoDAL(newed));
    }

    public org.apache.hadoop.hdfs.server.namenode.CachePool find(String key) throws StorageException {
        return this.convertDALtoHDFS((CachePool)this.dataAccess.find(key));
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.CachePool> findAboveName(String key) throws StorageException {
        return this.convertDALtoHDFS(this.dataAccess.findAboveName(key));
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.CachePool> findAll() throws StorageException {
        return this.convertDALtoHDFS(this.dataAccess.findAll());
    }
}

