/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EnsembleAuthTest
extends ClientBase {
    @Override
    @Before
    public void setUp() throws Exception {
        System.setProperty("zookeeper.authProvider.1", "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.EnsembleAuthenticationProvider");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("zookeeper.authProvider.1");
        System.clearProperty("zookeeper.ensembleAuthName");
        ProviderRegistry.removeProvider("ensemble");
    }

    @Test
    public void noAuth() throws Exception {
        this.resetEnsembleAuth(null, false);
        this.connectToEnsemble(null);
    }

    @Test
    public void emptyAuth() throws Exception {
        this.resetEnsembleAuth(null, true);
        this.connectToEnsemble("foo");
    }

    @Test
    public void skipAuth() throws Exception {
        this.resetEnsembleAuth("woo", true);
        this.connectToEnsemble(null);
    }

    @Test
    public void passAuth() throws Exception {
        this.resetEnsembleAuth("woo", true);
        this.connectToEnsemble("woo");
    }

    @Test
    public void passAuthCSV() throws Exception {
        this.resetEnsembleAuth(" foo,bar, baz ", true);
        this.connectToEnsemble("foo");
        this.connectToEnsemble("bar");
        this.connectToEnsemble("baz");
    }

    @Test(expected=KeeperException.ConnectionLossException.class)
    public void failAuth() throws Exception {
        this.resetEnsembleAuth("woo", true);
        this.connectToEnsemble("goo");
    }

    @Test(expected=KeeperException.AuthFailedException.class)
    public void removeEnsembleAuthProvider() throws Exception {
        this.resetEnsembleAuth(null, false);
        this.connectToEnsemble("goo");
    }

    private void connectToEnsemble(String auth) throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            if (auth != null) {
                zk.addAuthInfo("ensemble", auth.getBytes());
            }
            zk.getData("/", false, null);
        }
    }

    private void resetEnsembleAuth(String auth, boolean useAuth) throws Exception {
        this.stopServer();
        if (auth == null) {
            System.clearProperty("zookeeper.ensembleAuthName");
        } else {
            System.setProperty("zookeeper.ensembleAuthName", auth);
        }
        if (useAuth) {
            System.setProperty("zookeeper.authProvider.1", "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.EnsembleAuthenticationProvider");
        } else {
            System.clearProperty("zookeeper.authProvider.1");
        }
        ProviderRegistry.removeProvider("ensemble");
        ProviderRegistry.initialize();
        this.startServer();
    }
}

