/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.StatsTrack;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.SetQuotaCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperQuotaTest
extends ClientBase {
    @Test
    public void testQuota() throws Exception {
        TestableZooKeeper zk = this.createClient();
        String path = "/a/b/v";
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v/d", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        SetQuotaCommand.createQuota((ZooKeeper)zk, "/a/b/v", 5L, 10);
        String absolutePath = "/zookeeper/quota/a/b/v/zookeeper_limits";
        byte[] data = zk.getData(absolutePath, false, new Stat());
        StatsTrack st = new StatsTrack(new String(data));
        Assert.assertTrue((String)"bytes are set", (st.getBytes() == 5L ? 1 : 0) != 0);
        Assert.assertTrue((String)"num count is set", (st.getCount() == 10 ? 1 : 0) != 0);
        String statPath = "/zookeeper/quota/a/b/v/zookeeper_stats";
        byte[] qdata = zk.getData(statPath, false, new Stat());
        StatsTrack qst = new StatsTrack(new String(qdata));
        Assert.assertTrue((String)"bytes are set", (qst.getBytes() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((String)"count is set", (qst.getCount() == 2 ? 1 : 0) != 0);
        this.stopServer();
        this.startServer();
        this.stopServer();
        this.startServer();
        ZooKeeperServer server = this.serverFactory.getZooKeeperServer();
        Assert.assertNotNull((String)"Quota is still set", (Object)(server.getZKDatabase().getDataTree().getMaxPrefixWithQuota("/a/b/v") != null ? 1 : 0));
    }

    @Test
    public void testSetQuota() throws IOException, InterruptedException, KeeperException, MalformedPathException {
        TestableZooKeeper zk = this.createClient();
        String path = "/c1";
        String nodeData = "foo";
        zk.create(path, nodeData.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 10;
        long bytes = 5L;
        SetQuotaCommand.createQuota((ZooKeeper)zk, path, bytes, count);
        String absoluteLimitPath = "/zookeeper/quota" + path + "/" + "zookeeper_limits";
        byte[] data = zk.getData(absoluteLimitPath, false, null);
        StatsTrack st = new StatsTrack(new String(data));
        Assert.assertEquals((long)bytes, (long)st.getBytes());
        Assert.assertEquals((long)count, (long)st.getCount());
        String absoluteStatPath = "/zookeeper/quota" + path + "/" + "zookeeper_stats";
        data = zk.getData(absoluteStatPath, false, null);
        st = new StatsTrack(new String(data));
        Assert.assertEquals((long)nodeData.length(), (long)st.getBytes());
        Assert.assertEquals((long)1L, (long)st.getCount());
        String path2 = "/c1/c2";
        String nodeData2 = "bar";
        zk.create(path2, nodeData2.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        absoluteStatPath = "/zookeeper/quota" + path + "/" + "zookeeper_stats";
        data = zk.getData(absoluteStatPath, false, null);
        st = new StatsTrack(new String(data));
        Assert.assertEquals((long)(nodeData.length() + nodeData2.length()), (long)st.getBytes());
        Assert.assertEquals((long)2L, (long)st.getCount());
    }

    @Test
    public void testSetQuotaWhenSetQuotaOnParentOrChildPath() throws IOException, InterruptedException, KeeperException, MalformedPathException {
        TestableZooKeeper zk = this.createClient();
        zk.create("/c1", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/c1/c2", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/c1/c2/c3", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/c1/c2/c3/c4", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/c1/c2/c3/c4/c5", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        SetQuotaCommand.createQuota((ZooKeeper)zk, "/c1/c2/c3", 5L, 10);
        try {
            SetQuotaCommand.createQuota((ZooKeeper)zk, "/c1", 5L, 10);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"/c1 has a child /c1/c2/c3 which has a quota", (Object)e.getMessage());
        }
        try {
            SetQuotaCommand.createQuota((ZooKeeper)zk, "/c1/c2/c3/c4/c5", 5L, 10);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"/c1/c2/c3/c4/c5 has a parent /c1/c2/c3 which has a quota", (Object)e.getMessage());
        }
    }
}

