/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ExitCode;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.Collections;
import java.util.List;

public class SledgeHammer
extends Thread {
    ZooKeeper zk;
    int count;
    int readsPerWrite;

    public SledgeHammer(String hosts, int count, int readsPerWrite) throws Exception {
        this.zk = ClientBase.createZKClient(hosts, 10000);
        this.count = count;
        this.readsPerWrite = readsPerWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Stat stat = new Stat();
            String path = this.zk.create("/hammers/hammer-", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            byte[] tag = (path + " was here!").getBytes();
            SledgeHammer sledgeHammer = this;
            synchronized (sledgeHammer) {
                String startPath = "/hammers/start";
                System.out.println("Waiting for " + startPath);
                while (this.zk.exists(startPath, true) == null) {
                    this.wait();
                }
                System.out.println("Running");
            }
            block11: for (int i = 0; i < this.count; ++i) {
                try {
                    System.out.print(i + "\r");
                    List<String> childs = this.zk.getChildren("/hammers", false);
                    Collections.shuffle(childs);
                    for (String s : childs) {
                        if (!s.startsWith("hammer-")) continue;
                        s = "/hammers/" + s;
                        this.zk.setData(s, tag, -1);
                        for (int j = 0; j < this.readsPerWrite; ++j) {
                            this.zk.getData(s, false, stat);
                        }
                        continue block11;
                    }
                    continue;
                }
                catch (KeeperException.ConnectionLossException childs) {
                    continue;
                }
                catch (KeeperException e) {
                    e.printStackTrace();
                }
            }
            System.out.println();
            this.zk.close();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("USAGE: SledgeHammer zookeeper_server reps reads_per_rep");
            System.exit(ExitCode.UNABLE_TO_ACCESS_DATADIR.getValue());
        }
        SledgeHammer h = new SledgeHammer(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]));
        h.start();
        System.exit(ExitCode.EXECUTION_FINISHED.getValue());
    }
}

