/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.MultiOperationRecord;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class MultiOperationRecordTest
extends ZKTestCase {
    @Test
    public void testRoundTrip() throws IOException {
        MultiOperationRecord request = new MultiOperationRecord();
        request.add(Op.check("check", 1));
        request.add(Op.create("create", "create data".getBytes(), ZooDefs.Ids.CREATOR_ALL_ACL, 31));
        request.add(Op.delete("delete", 17));
        request.add(Op.setData("setData", "set data".getBytes(), 19));
        MultiOperationRecord decodedRequest = this.codeDecode(request);
        Assert.assertEquals((Object)request, (Object)decodedRequest);
        Assert.assertEquals((long)request.hashCode(), (long)decodedRequest.hashCode());
    }

    @Test
    public void testEmptyRoundTrip() throws IOException {
        MultiOperationRecord request = new MultiOperationRecord();
        MultiOperationRecord decodedRequest = this.codeDecode(request);
        Assert.assertEquals((Object)request, (Object)decodedRequest);
        Assert.assertEquals((long)request.hashCode(), (long)decodedRequest.hashCode());
    }

    private MultiOperationRecord codeDecode(MultiOperationRecord request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        request.serialize(boa, "request");
        baos.close();
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        bb.rewind();
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(bb));
        MultiOperationRecord decodedRequest = new MultiOperationRecord();
        decodedRequest.deserialize(bia, "request");
        return decodedRequest;
    }
}

