/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.http;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.ContentEncoding;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpCodecFilter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpContent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpHeader;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpPacket;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpProbe;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.TransferEncoding;

final class HttpProbeNotifier {
    HttpProbeNotifier() {
    }

    static void notifyDataReceived(HttpCodecFilter httpFilter, Connection connection, Buffer buffer) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onDataReceivedEvent(connection, buffer);
            }
        }
    }

    static void notifyDataSent(HttpCodecFilter httpFilter, Connection connection, Buffer buffer) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onDataSentEvent(connection, buffer);
            }
        }
    }

    static void notifyHeaderParse(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, int size) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onHeaderParseEvent(connection, header, size);
            }
        }
    }

    static void notifyHeaderSerialize(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onHeaderSerializeEvent(connection, header, buffer);
            }
        }
    }

    static void notifyContentChunkParse(HttpCodecFilter httpFilter, Connection connection, HttpContent content) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onContentChunkParseEvent(connection, content);
            }
        }
    }

    static void notifyContentChunkSerialize(HttpCodecFilter httpFilter, Connection connection, HttpContent content) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onContentChunkSerializeEvent(connection, content);
            }
        }
    }

    static void notifyContentEncodingParse(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onContentEncodingParseEvent(connection, header, buffer, contentEncoding);
            }
        }
    }

    static void notifyContentEncodingSerialize(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onContentEncodingSerializeEvent(connection, header, buffer, contentEncoding);
            }
        }
    }

    static void notifyTransferEncodingParse(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onTransferEncodingParseEvent(connection, header, buffer, transferEncoding);
            }
        }
    }

    static void notifyTransferEncodingSerialize(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpProbe probe : probes) {
                probe.onTransferEncodingSerializeEvent(connection, header, buffer, transferEncoding);
            }
        }
    }

    static void notifyProbesError(HttpCodecFilter httpFilter, Connection connection, HttpPacket httpPacket, Throwable error) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            if (error == null) {
                error = new IllegalStateException("Error in HTTP semantics");
            }
            for (HttpProbe probe : probes) {
                probe.onErrorEvent(connection, httpPacket, error);
            }
        }
    }
}

