/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import io.hops.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FifoSchedulerInfo;
import org.apache.hadoop.yarn.server.webapp.AppsBlock;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

class DefaultSchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float WIDTH_F = 0.8f;
    static final String Q_END = "left:101%";
    static final String OVER = "font-size:1px;background:#FFA333";
    static final String UNDER = "font-size:1px;background:#5BD75B";
    static final float EPSILON = 1.0E-8f;

    DefaultSchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage.__> html) {
        ((Hamlet.HTML)html.style().$type("text/css").__(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", "table.info tr th {width: 50%}"}).__()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript").__(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    data.inst.open_all(); }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'root') q = '';", "    $('#apps').dataTable().fnFilter(q, 4);", "  });", "  $('#cs').show();", "});"}).__();
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return StringUtils.formatPercent((double)f, (int)1);
    }

    static String width(float f) {
        return StringUtils.format((String)"width:%.1f%%", (Object[])new Object[]{Float.valueOf(f * 100.0f)});
    }

    static String left(float f) {
        return StringUtils.format((String)"left:%.1f%%", (Object[])new Object[]{Float.valueOf(f * 100.0f)});
    }

    static class QueuesBlock
    extends HtmlBlock {
        final FifoSchedulerInfo sinfo;
        final FifoScheduler fs;

        @Inject
        QueuesBlock(ResourceManager rm) {
            this.sinfo = new FifoSchedulerInfo(rm);
            this.fs = (FifoScheduler)rm.getResourceScheduler();
        }

        public void render(HtmlBlock.Block html) {
            html.__(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top").__(new Object[]{"FifoScheduler Queue"}).__()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.fs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(DefaultSchedulerPage._Q).$style(DefaultSchedulerPage.width(0.8f)).span().$style(DefaultSchedulerPage.Q_END).__(new Object[]{"100% "}).__()).span(".q", "default").__()).__();
            } else {
                float used = this.sinfo.getUsedCapacity();
                float set = this.sinfo.getCapacity();
                float delta = Math.abs(set - used) + 0.001f;
                ((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(DefaultSchedulerPage._Q).$style(DefaultSchedulerPage.width(0.8f)).$title(StringHelper.join((Object[])new Object[]{"used:", DefaultSchedulerPage.percent(used)})).span().$style(DefaultSchedulerPage.Q_END).__(new Object[]{"100%"}).__()).span().$style(StringHelper.join((Object[])new Object[]{DefaultSchedulerPage.width(delta), Character.valueOf(';'), used > set ? DefaultSchedulerPage.OVER : DefaultSchedulerPage.UNDER, Character.valueOf(';'), used > set ? DefaultSchedulerPage.left(set) : DefaultSchedulerPage.left(used)})).__(new Object[]{"."}).__()).span(".q", this.sinfo.getQueueName()).__()).__(QueueInfoBlock.class).__();
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul.__()).__()).script().$type("text/javascript").__(new Object[]{"$('#cs').hide();"}).__()).__()).__(AppsBlock.class);
        }
    }

    static class QueueInfoBlock
    extends HtmlBlock {
        final FifoSchedulerInfo sinfo;

        @Inject
        QueueInfoBlock(View.ViewContext ctx, ResourceManager rm) {
            super(ctx);
            this.sinfo = new FifoSchedulerInfo(rm);
        }

        public void render(HtmlBlock.Block html) {
            this.info("'" + this.sinfo.getQueueName() + "' Queue Status").__("Queue State:", (Object)this.sinfo.getState()).__("Minimum Queue Memory Capacity:", (Object)Long.toString(this.sinfo.getMinQueueMemoryCapacity())).__("Maximum Queue Memory Capacity:", (Object)Long.toString(this.sinfo.getMaxQueueMemoryCapacity())).__("Number of Nodes:", (Object)Integer.toString(this.sinfo.getNumNodes())).__("Used Node Capacity:", (Object)Integer.toString(this.sinfo.getUsedNodeCapacity())).__("Available Node Capacity:", (Object)Integer.toString(this.sinfo.getAvailNodeCapacity())).__("Total Node Capacity:", (Object)Integer.toString(this.sinfo.getTotalNodeCapacity())).__("Number of Node Containers:", (Object)Integer.toString(this.sinfo.getNumContainers()));
            html.__(InfoBlock.class);
        }
    }
}

