/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.Filter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChain;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class BaseFilter
implements Filter {
    private volatile int index;
    private volatile WeakReference<FilterChain> filterChain;

    @Override
    public void onAdded(FilterChain filterChain) {
        this.index = filterChain.indexOf(this);
        this.filterChain = new WeakReference<FilterChain>(filterChain);
    }

    @Override
    public void onFilterChainChanged(FilterChain filterChain) {
        this.index = filterChain.indexOf(this);
    }

    @Override
    public void onRemoved(FilterChain filterChain) {
        this.index = -1;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        return ctx.getInvokeAction();
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
    }

    public FilterChain getFilterChain() {
        WeakReference<FilterChain> localRef = this.filterChain;
        return localRef != null ? (FilterChain)localRef.get() : null;
    }

    public int getIndex() {
        return this.index;
    }

    public FilterChainContext createContext(Connection connection, FilterChainContext.Operation operation) {
        FilterChainContext ctx = this.getFilterChain().obtainFilterChainContext(connection);
        ctx.setOperation(operation);
        ctx.setFilterIdx(this.index);
        ctx.setStartIdx(this.index);
        return ctx;
    }
}

