/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.Time;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class TimeTest
extends ClientBase {
    private static final long mt0 = System.currentTimeMillis();
    private static final long nt0 = Time.currentElapsedTime();
    private static AtomicInteger watchCount = new AtomicInteger(0);

    public static void main(String[] args) throws Exception {
        System.out.print("Starting\n");
        TimeTest test2 = new TimeTest();
        System.out.print("After construct\n");
        test2.setUp();
        TestableZooKeeper zk = test2.createClient();
        zk.create("/ephemeral", new byte[]{1, 2, 3}, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        while (Time.currentElapsedTime() - nt0 < 100000L) {
            System.out.printf("%d\t%s\n", TimeTest.discrepancy(), zk.exists("/ephemeral", watchCount.get() == 0 ? TimeTest.createWatcher() : null) != null);
            TimeTest.waitByYielding(500L);
        }
    }

    private static Watcher createWatcher() {
        watchCount.incrementAndGet();
        return event -> {
            watchCount.decrementAndGet();
            System.out.printf("%d event = %s\n", TimeTest.discrepancy(), event);
        };
    }

    private static void waitByYielding(long delay) {
        long t0 = Time.currentElapsedTime();
        while (Time.currentElapsedTime() < t0 + delay) {
            Thread.yield();
        }
    }

    private static long discrepancy() {
        return System.currentTimeMillis() - mt0 - (Time.currentElapsedTime() - nt0);
    }

    @Test
    public void testElapsedTimeToDate() throws Exception {
        long walltime = Time.currentWallTime();
        long elapsedTime = Time.currentElapsedTime();
        Thread.sleep(200L);
        Calendar cal = Calendar.getInstance();
        cal.setTime(Time.elapsedTimeToDate(elapsedTime));
        int calculatedDate = cal.get(11);
        cal.setTime(new Date(walltime));
        int realDate = cal.get(11);
        Assert.assertEquals((long)calculatedDate, (long)realDate);
    }
}

