/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.DummyWatcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.CreateRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerStats;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FilePadding;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import io.hops.hadoop.shaded.org.hamcrest.core.Is;
import io.hops.hadoop.shaded.org.hamcrest.core.IsEqual;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnLogTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FileTxnLogTest.class);
    private static final int KB = 1024;
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int NODE_SIZE = 1024;
    private final long PREALLOCATE = 512L;
    private final long LOG_SIZE_LIMIT = 4096L;

    @Test
    public void testInvalidPreallocSize() {
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FilePadding.calculateFileSizeWithPadding(7168L, 10240L, 0L));
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FilePadding.calculateFileSizeWithPadding(7168L, 10240L, -1L));
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenNotToCurrentSize() {
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FilePadding.calculateFileSizeWithPadding(5120L, 10240L, 10240L));
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenCloseToCurrentSize() {
        Assert.assertEquals((String)"file should be padded an additional 10 KB", (long)20480L, (long)FilePadding.calculateFileSizeWithPadding(7168L, 10240L, 10240L));
    }

    @Test
    public void testFileSizeGreaterThanPosition() {
        Assert.assertEquals((String)"file should be padded to 40 KB", (long)40960L, (long)FilePadding.calculateFileSizeWithPadding(31744L, 10240L, 10240L));
    }

    @Test
    public void testPreAllocSizeSmallerThanTxnData() throws IOException {
        File logDir = ClientBase.createTmpDir();
        FileTxnLog fileTxnLog = new FileTxnLog(logDir);
        int preAllocSize = 512000;
        FilePadding.setPreallocSize(512000L);
        byte[] data = new byte[1024000];
        Arrays.fill(data, (byte)-1);
        fileTxnLog.append(new TxnHeader(1L, 1, 1L, 1L, 1), new CreateTxn("/testPreAllocSizeSmallerThanTxnData1", data, ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
        fileTxnLog.commit();
        fileTxnLog.append(new TxnHeader(1L, 1, 2L, 2L, 1), new CreateTxn("/testPreAllocSizeSmallerThanTxnData2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
        fileTxnLog.commit();
        fileTxnLog.close();
        FileTxnLog.FileTxnIterator fileTxnIterator = new FileTxnLog.FileTxnIterator(logDir, 0L);
        CreateTxn createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assert.assertTrue((boolean)Arrays.equals(createTxn.getData(), data));
        fileTxnIterator.next();
        createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assert.assertTrue((boolean)Arrays.equals(createTxn.getData(), new byte[0]));
    }

    @Test
    public void testSetPreallocSize() {
        long customPreallocSize = 10101L;
        FileTxnLog.setPreallocSize(customPreallocSize);
        Assert.assertThat((Object)FilePadding.getPreAllocSize(), Is.is(IsEqual.equalTo(customPreallocSize)));
    }

    public void testSyncThresholdExceedCount() throws IOException {
        System.setProperty("zookeeper.fsync.warningthresholdms", "-1");
        ServerStats.Provider providerMock = Mockito.mock(ServerStats.Provider.class);
        ServerStats serverStats = new ServerStats(providerMock);
        File logDir = ClientBase.createTmpDir();
        FileTxnLog fileTxnLog = new FileTxnLog(logDir);
        fileTxnLog.setServerStats(serverStats);
        Assert.assertEquals((long)0L, (long)serverStats.getFsyncThresholdExceedCount());
        for (int i = 0; i < 50; ++i) {
            fileTxnLog.append(new TxnHeader(1L, 1, 1L, 1L, 1), new CreateTxn("/testFsyncThresholdCountIncreased", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
            fileTxnLog.commit();
            Assert.assertEquals((long)((long)i + 1L), (long)serverStats.getFsyncThresholdExceedCount());
        }
    }

    @Test
    public void testGetCurrentLogSize() throws Exception {
        int i;
        FileTxnLog.setTxnLogSizeLimit(-1L);
        File tmpDir = ClientBase.createTmpDir();
        FileTxnLog log = new FileTxnLog(tmpDir);
        FileTxnLog.setPreallocSize(512L);
        CreateRequest record = new CreateRequest(null, new byte[1024], ZooDefs.Ids.OPEN_ACL_UNSAFE, 0);
        int zxid = 1;
        for (i = 0; i < 4; ++i) {
            log.append(new TxnHeader(0L, 0, zxid++, 0L, 0), record);
            LOG.debug("Current log size: {}", (Object)log.getCurrentLogSize());
        }
        log.commit();
        LOG.info("Current log size: {}", (Object)log.getCurrentLogSize());
        Assert.assertTrue((log.getCurrentLogSize() > (long)((zxid - 1) * 1024) ? 1 : 0) != 0);
        for (i = 0; i < 4; ++i) {
            log.append(new TxnHeader(0L, 0, zxid++, 0L, 0), record);
            LOG.debug("Current log size: {}", (Object)log.getCurrentLogSize());
        }
        log.commit();
        LOG.info("Current log size: " + log.getCurrentLogSize());
        Assert.assertTrue((log.getCurrentLogSize() > (long)((zxid - 1) * 1024) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogSizeLimit() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        FileTxnLog.setPreallocSize(512L);
        FileTxnLog.setTxnLogSizeLimit(4096L);
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, DummyWatcher.INSTANCE);
        HashSet<Long> zxids = new HashSet<Long>();
        byte[] bytes = new byte[1024];
        Random random = new Random();
        random.nextBytes(bytes);
        long txnCount = 10L;
        LOG.info("Creating {} txns", (Object)txnCount);
        try {
            for (long i = 0L; i < txnCount; ++i) {
                Stat stat = new Stat();
                zk.create("/node-" + i, bytes, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.getData("/node-" + i, null, stat);
                zxids.add(stat.getCzxid());
            }
        }
        finally {
            zk.close();
        }
        f.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        File logDir = new File(tmpDir, "version-2");
        File[] txnLogs = FileTxnLog.getLogFiles(logDir.listFiles(), 0L);
        Assert.assertEquals((String)"Unexpected number of logs", (long)3L, (long)txnLogs.length);
        long threshold = 5120L;
        LOG.info(txnLogs[0].getAbsolutePath());
        Assert.assertTrue((String)("Exceed log size limit: " + txnLogs[0].length()), (threshold > txnLogs[0].length() ? 1 : 0) != 0);
        LOG.info(txnLogs[1].getAbsolutePath());
        Assert.assertTrue((String)("Exceed log size limit " + txnLogs[1].length()), (threshold > txnLogs[1].length() ? 1 : 0) != 0);
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        zks.startdata();
        ZKDatabase db = zks.getZKDatabase();
        for (long i = 0L; i < txnCount; ++i) {
            Stat stat = new Stat();
            byte[] data = db.getData("/node-" + i, stat, null);
            Assert.assertArrayEquals((String)"Missmatch data", (byte[])bytes, (byte[])data);
            Assert.assertTrue((String)"Unknown zxid ", (boolean)zxids.contains(stat.getMzxid()));
        }
    }
}

