/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.google.inject.servlet;

import io.hops.hadoop.shaded.com.google.inject.AbstractModule;
import io.hops.hadoop.shaded.com.google.inject.Inject;
import io.hops.hadoop.shaded.com.google.inject.Key;
import io.hops.hadoop.shaded.com.google.inject.Provider;
import io.hops.hadoop.shaded.com.google.inject.Provides;
import io.hops.hadoop.shaded.com.google.inject.Singleton;
import io.hops.hadoop.shaded.com.google.inject.servlet.DefaultFilterPipeline;
import io.hops.hadoop.shaded.com.google.inject.servlet.FilterPipeline;
import io.hops.hadoop.shaded.com.google.inject.servlet.GuiceFilter;
import io.hops.hadoop.shaded.com.google.inject.servlet.ManagedFilterPipeline;
import io.hops.hadoop.shaded.com.google.inject.servlet.ManagedServletPipeline;
import io.hops.hadoop.shaded.com.google.inject.servlet.RequestParameters;
import io.hops.hadoop.shaded.com.google.inject.servlet.RequestScoped;
import io.hops.hadoop.shaded.com.google.inject.servlet.ScopingOnly;
import io.hops.hadoop.shaded.com.google.inject.servlet.ServletScopes;
import io.hops.hadoop.shaded.com.google.inject.servlet.SessionScoped;
import io.hops.hadoop.shaded.javax.servlet.ServletContext;
import io.hops.hadoop.shaded.javax.servlet.ServletRequest;
import io.hops.hadoop.shaded.javax.servlet.ServletResponse;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.javax.servlet.http.HttpSession;
import java.util.Map;
import java.util.logging.Logger;

final class InternalServletModule
extends AbstractModule {
    InternalServletModule() {
    }

    @Override
    protected void configure() {
        this.bindScope(RequestScoped.class, ServletScopes.REQUEST);
        this.bindScope(SessionScoped.class, ServletScopes.SESSION);
        this.bind(ServletRequest.class).to(HttpServletRequest.class);
        this.bind(ServletResponse.class).to(HttpServletResponse.class);
        this.requestStaticInjection(GuiceFilter.class);
        this.bind(ManagedFilterPipeline.class);
        this.bind(ManagedServletPipeline.class);
        this.bind(FilterPipeline.class).to(ManagedFilterPipeline.class).asEagerSingleton();
        this.bind(ServletContext.class).toProvider(BackwardsCompatibleServletContextProvider.class);
        this.bind(BackwardsCompatibleServletContextProvider.class);
    }

    @Provides
    @Singleton
    @ScopingOnly
    GuiceFilter provideScopingOnlyGuiceFilter() {
        return new GuiceFilter(new DefaultFilterPipeline());
    }

    @Provides
    @RequestScoped
    HttpServletRequest provideHttpServletRequest() {
        return GuiceFilter.getRequest(Key.get(HttpServletRequest.class));
    }

    @Provides
    @RequestScoped
    HttpServletResponse provideHttpServletResponse() {
        return GuiceFilter.getResponse(Key.get(HttpServletResponse.class));
    }

    @Provides
    HttpSession provideHttpSession() {
        return GuiceFilter.getRequest(Key.get(HttpSession.class)).getSession();
    }

    @Provides
    @RequestScoped
    @RequestParameters
    Map<String, String[]> provideRequestParameters(ServletRequest req) {
        return req.getParameterMap();
    }

    public boolean equals(Object o) {
        return o instanceof InternalServletModule;
    }

    public int hashCode() {
        return InternalServletModule.class.hashCode();
    }

    @Singleton
    static class BackwardsCompatibleServletContextProvider
    implements Provider<ServletContext> {
        private ServletContext injectedServletContext;

        @Inject
        BackwardsCompatibleServletContextProvider() {
        }

        void set(ServletContext injectedServletContext) {
            this.injectedServletContext = injectedServletContext;
        }

        @Override
        public ServletContext get() {
            if (null != this.injectedServletContext) {
                return this.injectedServletContext;
            }
            Logger.getLogger(InternalServletModule.class.getName()).warning("You are attempting to use a deprecated API (specifically, attempting to @Inject ServletContext inside an eagerly created singleton. While we allow this for backwards compatibility, be warned that this MAY have unexpected behavior if you have more than one injector (with ServletModule) running in the same JVM. Please consult the Guice documentation at https://github.com/google/guice/wiki/Servlets for more information.");
            return GuiceFilter.getServletContext();
        }
    }
}

