/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.metrics.MetricsUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Learner;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.hamcrest.core.Is;
import io.hops.hadoop.shaded.org.hamcrest.number.OrderingComparison;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LearnerMetricsTest
extends QuorumPeerTestBase {
    private static final int TIMEOUT_SECONDS = 30;
    private static final int SERVER_COUNT = 4;
    private final QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[4];
    private ZooKeeper zk_client;
    private boolean asyncSending;
    private static boolean bakAsyncSending;

    public LearnerMetricsTest(boolean asyncSending) {
        this.asyncSending = asyncSending;
    }

    @Parameterized.Parameters
    public static Collection sendingModes() {
        return Arrays.asList({true}, {false});
    }

    @Before
    public void setAsyncSendingFlag() {
        Learner.setAsyncSending(this.asyncSending);
    }

    @BeforeClass
    public static void saveAsyncSendingFlag() {
        bakAsyncSending = Learner.getAsyncSending();
    }

    @AfterClass
    public static void resetAsyncSendingFlag() {
        Learner.setAsyncSending(bakAsyncSending);
    }

    @Test
    public void testLearnerMetricsTest() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        ClientBase.setupTestEnv();
        String path = "/zk-testLeanerMetrics";
        byte[] data = new byte[512];
        int[] clientPorts = new int[4];
        StringBuilder sb = new StringBuilder();
        int observer = 0;
        clientPorts[observer] = PortAssignment.unique();
        sb.append("server." + observer + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer\n");
        for (int i = 1; i < 4; ++i) {
            clientPorts[i] = PortAssignment.unique();
            sb.append("server." + i + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
        }
        String quorumCfgSection = sb.toString();
        for (int i = 1; i < 4; ++i) {
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], quorumCfgSection);
            this.mt[i].start();
        }
        HashMap<String, String> observerConfig = new HashMap<String, String>();
        observerConfig.put("peerType", "observer");
        this.mt[observer] = new QuorumPeerTestBase.MainThread(observer, clientPorts[observer], quorumCfgSection, observerConfig);
        this.mt[observer].start();
        this.zk_client = new ZooKeeper("127.0.0.1:" + clientPorts[observer], ClientBase.CONNECTION_TIMEOUT, this);
        LearnerMetricsTest.waitForOne(this.zk_client, ZooKeeper.States.CONNECTED);
        this.zk_client.create("/zk-testLeanerMetrics", data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.waitForMetric("learner_proposal_received_count", Is.is(4L));
        this.waitForMetric("cnt_proposal_latency", Is.is(4L));
        this.waitForMetric("min_proposal_latency", OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        this.waitForMetric("cnt_proposal_ack_creation_latency", Is.is(6L));
        this.waitForMetric("min_proposal_ack_creation_latency", OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        this.waitForMetric("learner_commit_received_count", Is.is(6L));
        this.waitForMetric("cnt_commit_propagation_latency", Is.is(6L));
        this.waitForMetric("min_commit_propagation_latency", OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
    }

    private void waitForMetric(String metricKey, Matcher<Long> matcher) throws InterruptedException {
        String errorMessage = String.format("unable to match on metric: %s", metricKey);
        this.waitFor(errorMessage, () -> {
            long actual = (Long)MetricsUtils.currentServerMetrics().get(metricKey);
            if (!matcher.matches(actual)) {
                LOG.info("match failed on {}, actual value: {}", (Object)metricKey, (Object)actual);
                return false;
            }
            return true;
        }, 30);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.zk_client.close();
        for (int i = 0; i < 4; ++i) {
            this.mt[i].shutdown();
        }
    }
}

