/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxnSocketNIO;
import io.hops.hadoop.shaded.org.apache.zookeeper.ClientWatchManager;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.HostProvider;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.ZKClientConfig;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class ClientReconnectTest
extends ZKTestCase {
    private SocketChannel sc;
    private CountDownLatch countDownLatch = new CountDownLatch(3);

    @Test
    public void testClientReconnect() throws IOException, InterruptedException {
        HostProvider hostProvider = Mockito.mock(HostProvider.class);
        Mockito.when(hostProvider.size()).thenReturn(1);
        InetSocketAddress inaddr = new InetSocketAddress("127.0.0.1", 1111);
        Mockito.when(hostProvider.next(ArgumentMatchers.anyLong())).thenReturn(inaddr);
        ZooKeeper zk = Mockito.mock(ZooKeeper.class);
        Mockito.when(zk.getClientConfig()).thenReturn(new ZKClientConfig());
        this.sc = SocketChannel.open();
        MockCnxn nioCnxn = new MockCnxn();
        ClientWatchManager watcher = Mockito.mock(ClientWatchManager.class);
        ClientCnxn clientCnxn = new ClientCnxn("tmp", hostProvider, 5000, zk, watcher, nioCnxn, false);
        clientCnxn.start();
        this.countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((this.countDownLatch.getCount() == 0L ? 1 : 0) != 0);
        clientCnxn.close();
    }

    class MockCnxn
    extends ClientCnxnSocketNIO {
        MockCnxn() throws IOException {
            super(new ZKClientConfig());
        }

        @Override
        void registerAndConnect(SocketChannel sock, InetSocketAddress addr) throws IOException {
            ClientReconnectTest.this.countDownLatch.countDown();
            throw new IOException("failed to register");
        }

        @Override
        SocketChannel createSock() {
            return ClientReconnectTest.this.sc;
        }
    }
}

