/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509KeyType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509TestHelpers;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Util;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x500.X500NameBuilder;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x500.style.BCStyle;
import io.hops.hadoop.shaded.org.bouncycastle.operator.OperatorCreationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;

public class X509TestContext {
    private static final String TRUST_STORE_PREFIX = "zk_test_ca";
    private static final String KEY_STORE_PREFIX = "zk_test_key";
    private final File tempDir;
    private final X509KeyType trustStoreKeyType;
    private final KeyPair trustStoreKeyPair;
    private final long trustStoreCertExpirationMillis;
    private final X509Certificate trustStoreCertificate;
    private final String trustStorePassword;
    private File trustStoreJksFile;
    private File trustStorePemFile;
    private File trustStorePkcs12File;
    private File trustStoreBcfksFile;
    private final X509KeyType keyStoreKeyType;
    private final KeyPair keyStoreKeyPair;
    private final long keyStoreCertExpirationMillis;
    private final X509Certificate keyStoreCertificate;
    private final String keyStorePassword;
    private File keyStoreJksFile;
    private File keyStorePemFile;
    private File keyStorePkcs12File;
    private File keyStoreBcfksFile;
    private final Boolean hostnameVerification;

    private X509TestContext(File tempDir, KeyPair trustStoreKeyPair, long trustStoreCertExpirationMillis, String trustStorePassword, KeyPair keyStoreKeyPair, long keyStoreCertExpirationMillis, String keyStorePassword, Boolean hostnameVerification) throws IOException, GeneralSecurityException, OperatorCreationException {
        if (Security.getProvider("BC") == null) {
            throw new IllegalStateException("BC Security provider was not found");
        }
        this.tempDir = Objects.requireNonNull(tempDir);
        if (!tempDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + tempDir);
        }
        this.trustStoreKeyPair = Objects.requireNonNull(trustStoreKeyPair);
        this.trustStoreKeyType = this.keyPairToType(trustStoreKeyPair);
        this.trustStoreCertExpirationMillis = trustStoreCertExpirationMillis;
        this.trustStorePassword = Objects.requireNonNull(trustStorePassword);
        this.keyStoreKeyPair = Objects.requireNonNull(keyStoreKeyPair);
        this.keyStoreKeyType = this.keyPairToType(keyStoreKeyPair);
        this.keyStoreCertExpirationMillis = keyStoreCertExpirationMillis;
        this.keyStorePassword = Objects.requireNonNull(keyStorePassword);
        X500NameBuilder caNameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        caNameBuilder.addRDN(BCStyle.CN, MethodHandles.lookup().lookupClass().getCanonicalName() + " Root CA");
        this.trustStoreCertificate = X509TestHelpers.newSelfSignedCACert(caNameBuilder.build(), trustStoreKeyPair, trustStoreCertExpirationMillis);
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, MethodHandles.lookup().lookupClass().getCanonicalName() + " Zookeeper Test");
        this.keyStoreCertificate = X509TestHelpers.newCert(this.trustStoreCertificate, trustStoreKeyPair, nameBuilder.build(), keyStoreKeyPair.getPublic(), keyStoreCertExpirationMillis);
        this.trustStoreJksFile = null;
        this.trustStorePemFile = null;
        this.trustStorePkcs12File = null;
        this.keyStoreJksFile = null;
        this.keyStorePemFile = null;
        this.keyStorePkcs12File = null;
        this.hostnameVerification = hostnameVerification;
    }

    private X509KeyType keyPairToType(KeyPair keyPair) {
        if (keyPair.getPrivate().getAlgorithm().contains("RSA")) {
            return X509KeyType.RSA;
        }
        return X509KeyType.EC;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public X509KeyType getTrustStoreKeyType() {
        return this.trustStoreKeyType;
    }

    public KeyPair getTrustStoreKeyPair() {
        return this.trustStoreKeyPair;
    }

    public long getTrustStoreCertExpirationMillis() {
        return this.trustStoreCertExpirationMillis;
    }

    public X509Certificate getTrustStoreCertificate() {
        return this.trustStoreCertificate;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public File getTrustStoreFile(KeyStoreFileType storeFileType) throws IOException {
        switch (storeFileType) {
            case JKS: {
                return this.getTrustStoreJksFile();
            }
            case PEM: {
                return this.getTrustStorePemFile();
            }
            case PKCS12: {
                return this.getTrustStorePkcs12File();
            }
            case BCFKS: {
                return this.getTrustStoreBcfksFile();
            }
        }
        throw new IllegalArgumentException("Invalid trust store type: " + (Object)((Object)storeFileType) + ", must be one of: " + Arrays.toString((Object[])KeyStoreFileType.values()));
    }

    private File getTrustStoreJksFile() throws IOException {
        if (this.trustStoreJksFile == null) {
            File trustStoreJksFile = File.createTempFile(TRUST_STORE_PREFIX, KeyStoreFileType.JKS.getDefaultFileExtension(), this.tempDir);
            trustStoreJksFile.deleteOnExit();
            try (FileOutputStream trustStoreOutputStream = new FileOutputStream(trustStoreJksFile);){
                byte[] bytes = X509TestHelpers.certToJavaTrustStoreBytes(this.trustStoreCertificate, this.trustStorePassword);
                trustStoreOutputStream.write(bytes);
                trustStoreOutputStream.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.trustStoreJksFile = trustStoreJksFile;
        }
        return this.trustStoreJksFile;
    }

    private File getTrustStorePemFile() throws IOException {
        if (this.trustStorePemFile == null) {
            File trustStorePemFile = File.createTempFile(TRUST_STORE_PREFIX, KeyStoreFileType.PEM.getDefaultFileExtension(), this.tempDir);
            trustStorePemFile.deleteOnExit();
            FileUtils.writeStringToFile((File)trustStorePemFile, (String)X509TestHelpers.pemEncodeX509Certificate(this.trustStoreCertificate), (Charset)StandardCharsets.US_ASCII, (boolean)false);
            this.trustStorePemFile = trustStorePemFile;
        }
        return this.trustStorePemFile;
    }

    private File getTrustStorePkcs12File() throws IOException {
        if (this.trustStorePkcs12File == null) {
            File trustStorePkcs12File = File.createTempFile(TRUST_STORE_PREFIX, KeyStoreFileType.PKCS12.getDefaultFileExtension(), this.tempDir);
            trustStorePkcs12File.deleteOnExit();
            try (FileOutputStream trustStoreOutputStream = new FileOutputStream(trustStorePkcs12File);){
                byte[] bytes = X509TestHelpers.certToPKCS12TrustStoreBytes(this.trustStoreCertificate, this.trustStorePassword);
                trustStoreOutputStream.write(bytes);
                trustStoreOutputStream.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.trustStorePkcs12File = trustStorePkcs12File;
        }
        return this.trustStorePkcs12File;
    }

    private File getTrustStoreBcfksFile() throws IOException {
        if (this.trustStoreBcfksFile == null) {
            File trustStoreBcfksFile = File.createTempFile(TRUST_STORE_PREFIX, KeyStoreFileType.BCFKS.getDefaultFileExtension(), this.tempDir);
            trustStoreBcfksFile.deleteOnExit();
            try (FileOutputStream trustStoreOutputStream = new FileOutputStream(trustStoreBcfksFile);){
                byte[] bytes = X509TestHelpers.certToBCFKSTrustStoreBytes(this.trustStoreCertificate, this.trustStorePassword);
                trustStoreOutputStream.write(bytes);
                trustStoreOutputStream.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.trustStoreBcfksFile = trustStoreBcfksFile;
        }
        return this.trustStoreBcfksFile;
    }

    public X509KeyType getKeyStoreKeyType() {
        return this.keyStoreKeyType;
    }

    public KeyPair getKeyStoreKeyPair() {
        return this.keyStoreKeyPair;
    }

    public long getKeyStoreCertExpirationMillis() {
        return this.keyStoreCertExpirationMillis;
    }

    public X509Certificate getKeyStoreCertificate() {
        return this.keyStoreCertificate;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public boolean isKeyStoreEncrypted() {
        return this.keyStorePassword.length() > 0;
    }

    public File getKeyStoreFile(KeyStoreFileType storeFileType) throws IOException {
        switch (storeFileType) {
            case JKS: {
                return this.getKeyStoreJksFile();
            }
            case PEM: {
                return this.getKeyStorePemFile();
            }
            case PKCS12: {
                return this.getKeyStorePkcs12File();
            }
            case BCFKS: {
                return this.getKeyStoreBcfksFile();
            }
        }
        throw new IllegalArgumentException("Invalid key store type: " + (Object)((Object)storeFileType) + ", must be one of: " + Arrays.toString((Object[])KeyStoreFileType.values()));
    }

    private File getKeyStoreJksFile() throws IOException {
        if (this.keyStoreJksFile == null) {
            File keyStoreJksFile = File.createTempFile(KEY_STORE_PREFIX, KeyStoreFileType.JKS.getDefaultFileExtension(), this.tempDir);
            keyStoreJksFile.deleteOnExit();
            try (FileOutputStream keyStoreOutputStream = new FileOutputStream(keyStoreJksFile);){
                byte[] bytes = X509TestHelpers.certAndPrivateKeyToJavaKeyStoreBytes(this.keyStoreCertificate, this.keyStoreKeyPair.getPrivate(), this.keyStorePassword);
                keyStoreOutputStream.write(bytes);
                keyStoreOutputStream.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.keyStoreJksFile = keyStoreJksFile;
        }
        return this.keyStoreJksFile;
    }

    private File getKeyStorePemFile() throws IOException {
        if (this.keyStorePemFile == null) {
            try {
                File keyStorePemFile = File.createTempFile(KEY_STORE_PREFIX, KeyStoreFileType.PEM.getDefaultFileExtension(), this.tempDir);
                keyStorePemFile.deleteOnExit();
                FileUtils.writeStringToFile((File)keyStorePemFile, (String)X509TestHelpers.pemEncodeCertAndPrivateKey(this.keyStoreCertificate, this.keyStoreKeyPair.getPrivate(), this.keyStorePassword), (Charset)StandardCharsets.US_ASCII, (boolean)false);
                this.keyStorePemFile = keyStorePemFile;
            }
            catch (OperatorCreationException e) {
                throw new IOException(e);
            }
        }
        return this.keyStorePemFile;
    }

    private File getKeyStorePkcs12File() throws IOException {
        if (this.keyStorePkcs12File == null) {
            File keyStorePkcs12File = File.createTempFile(KEY_STORE_PREFIX, KeyStoreFileType.PKCS12.getDefaultFileExtension(), this.tempDir);
            keyStorePkcs12File.deleteOnExit();
            try (FileOutputStream keyStoreOutputStream = new FileOutputStream(keyStorePkcs12File);){
                byte[] bytes = X509TestHelpers.certAndPrivateKeyToPKCS12Bytes(this.keyStoreCertificate, this.keyStoreKeyPair.getPrivate(), this.keyStorePassword);
                keyStoreOutputStream.write(bytes);
                keyStoreOutputStream.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.keyStorePkcs12File = keyStorePkcs12File;
        }
        return this.keyStorePkcs12File;
    }

    private File getKeyStoreBcfksFile() throws IOException {
        if (this.keyStoreBcfksFile == null) {
            File keyStoreBcfksFile = File.createTempFile(KEY_STORE_PREFIX, KeyStoreFileType.BCFKS.getDefaultFileExtension(), this.tempDir);
            keyStoreBcfksFile.deleteOnExit();
            try (FileOutputStream keyStoreOutputStream = new FileOutputStream(keyStoreBcfksFile);){
                byte[] bytes = X509TestHelpers.certAndPrivateKeyToBCFKSBytes(this.keyStoreCertificate, this.keyStoreKeyPair.getPrivate(), this.keyStorePassword);
                keyStoreOutputStream.write(bytes);
                keyStoreOutputStream.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.keyStoreBcfksFile = keyStoreBcfksFile;
        }
        return this.keyStoreBcfksFile;
    }

    public void setSystemProperties(X509Util x509Util, KeyStoreFileType keyStoreFileType, KeyStoreFileType trustStoreFileType) throws IOException {
        System.setProperty(x509Util.getSslKeystoreLocationProperty(), this.getKeyStoreFile(keyStoreFileType).getAbsolutePath());
        System.setProperty(x509Util.getSslKeystorePasswdProperty(), this.getKeyStorePassword());
        System.setProperty(x509Util.getSslKeystoreTypeProperty(), keyStoreFileType.getPropertyValue());
        System.setProperty(x509Util.getSslTruststoreLocationProperty(), this.getTrustStoreFile(trustStoreFileType).getAbsolutePath());
        System.setProperty(x509Util.getSslTruststorePasswdProperty(), this.getTrustStorePassword());
        System.setProperty(x509Util.getSslTruststoreTypeProperty(), trustStoreFileType.getPropertyValue());
        if (this.hostnameVerification != null) {
            System.setProperty(x509Util.getSslHostnameVerificationEnabledProperty(), this.hostnameVerification.toString());
        } else {
            System.clearProperty(x509Util.getSslHostnameVerificationEnabledProperty());
        }
    }

    public void clearSystemProperties(X509Util x509Util) {
        System.clearProperty(x509Util.getSslKeystoreLocationProperty());
        System.clearProperty(x509Util.getSslKeystorePasswdProperty());
        System.clearProperty(x509Util.getSslKeystoreTypeProperty());
        System.clearProperty(x509Util.getSslTruststoreLocationProperty());
        System.clearProperty(x509Util.getSslTruststorePasswdProperty());
        System.clearProperty(x509Util.getSslTruststoreTypeProperty());
        System.clearProperty(x509Util.getSslHostnameVerificationEnabledProperty());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        public static final long DEFAULT_CERT_EXPIRATION_MILLIS = 86400000L;
        private File tempDir;
        private X509KeyType trustStoreKeyType = X509KeyType.EC;
        private String trustStorePassword = "";
        private long trustStoreCertExpirationMillis = 86400000L;
        private X509KeyType keyStoreKeyType = X509KeyType.EC;
        private String keyStorePassword = "";
        private long keyStoreCertExpirationMillis = 86400000L;
        private Boolean hostnameVerification = null;

        public X509TestContext build() throws IOException, GeneralSecurityException, OperatorCreationException {
            KeyPair trustStoreKeyPair = X509TestHelpers.generateKeyPair(this.trustStoreKeyType);
            KeyPair keyStoreKeyPair = X509TestHelpers.generateKeyPair(this.keyStoreKeyType);
            return new X509TestContext(this.tempDir, trustStoreKeyPair, this.trustStoreCertExpirationMillis, this.trustStorePassword, keyStoreKeyPair, this.keyStoreCertExpirationMillis, this.keyStorePassword, this.hostnameVerification);
        }

        public Builder setTempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder setTrustStoreKeyType(X509KeyType keyType) {
            this.trustStoreKeyType = keyType;
            return this;
        }

        public Builder setTrustStorePassword(String password) {
            this.trustStorePassword = password;
            return this;
        }

        public Builder setTrustStoreCertExpirationMillis(long expirationMillis) {
            this.trustStoreCertExpirationMillis = expirationMillis;
            return this;
        }

        public Builder setKeyStoreKeyType(X509KeyType keyType) {
            this.keyStoreKeyType = keyType;
            return this;
        }

        public Builder setKeyStorePassword(String password) {
            this.keyStorePassword = password;
            return this;
        }

        public Builder setKeyStoreCertExpirationMillis(long expirationMillis) {
            this.keyStoreCertExpirationMillis = expirationMillis;
            return this;
        }

        public Builder setHostnameVerification(Boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }
    }
}

