/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.offheap.structs.structtypes;

import io.hops.hadoop.shaded.org.nustaq.offheap.bytez.Bytez;
import io.hops.hadoop.shaded.org.nustaq.offheap.structs.FSTStruct;
import io.hops.hadoop.shaded.org.nustaq.offheap.structs.NoAssist;
import io.hops.hadoop.shaded.org.nustaq.offheap.structs.Templated;
import java.util.Iterator;

public class StructArray<E extends FSTStruct>
extends FSTStruct {
    @Templated
    protected Object[] elems = new Object[]{null};
    protected transient E template;

    @NoAssist
    public StructArray(int size, E template) {
        if (size < 1) {
            throw new RuntimeException("minimum size is 1");
        }
        this.elems = new Object[size];
        this.elems[0] = template;
    }

    @NoAssist
    public E getTemplate() {
        return this.template;
    }

    protected Object elems(int i) {
        return this.elems[i];
    }

    protected void elems(int i, Object val) {
        this.elems[i] = val;
    }

    protected int elemsLen() {
        return this.elems.length;
    }

    protected Object elemsPointer() {
        return null;
    }

    protected int elemsStructIndex() {
        return -1;
    }

    @NoAssist
    public E get(int i) {
        return (E)((FSTStruct)this.elems(i));
    }

    @NoAssist
    public void set(int i, E value) {
        this.elems(i, value);
    }

    @NoAssist
    public int size() {
        return this.elemsLen();
    }

    @NoAssist
    public StructArrIterator<E> iterator() {
        return new StructArrIterator();
    }

    @NoAssist
    public E createPointer(int index) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        FSTStruct res = (FSTStruct)this.elemsPointer();
        res.___elementSize = res.getByteSize();
        res.___offset += (long)(index * res.___elementSize);
        return (E)res;
    }

    public String toString() {
        return "StructArray{elemSize=" + this.getStructElemSize() + ", size=" + this.size() + '}';
    }

    @NoAssist
    public int getStructElemSize() {
        if (this.isOffHeap()) {
            return this.___bytes.getInt(this.elemsStructIndex() + 8);
        }
        return -1;
    }

    @NoAssist
    public int getStructElemClassId() {
        if (this.isOffHeap()) {
            return this.___bytes.getInt(this.elemsStructIndex() + 12);
        }
        return -1;
    }

    public void clear(int currentIndex) {
        if (this.template == null) {
            throw new RuntimeException("not avaiable in embedded struct arrays. Use set(i,template) instead.");
        }
        this.set(currentIndex, this.template);
    }

    public void ___setTemplate(E template) {
        this.template = template;
    }

    public class StructArrIterator<T extends FSTStruct>
    implements Iterator<T> {
        T current;
        final long maxPos;
        final int eSiz;
        final Bytez bytes;
        boolean hasNextElem = true;

        StructArrIterator() {
            this.bytes = StructArray.this.___bytes;
            this.eSiz = StructArray.this.getStructElemSize();
            this.current = StructArray.this.createPointer(0);
            ((FSTStruct)this.current).___offset -= (long)this.eSiz;
            this.maxPos = (long)(StructArray.this.size() * this.eSiz) + ((FSTStruct)StructArray.this.get((int)0)).___offset;
            this.hasNextElem = ((FSTStruct)this.current).___offset < this.maxPos;
        }

        @Override
        public final boolean hasNext() {
            return this.hasNextElem;
        }

        @Override
        public final T next() {
            ((FSTStruct)this.current).___offset += (long)this.eSiz;
            this.hasNextElem = ((FSTStruct)this.current).___offset + (long)this.eSiz < this.maxPos;
            return this.current;
        }

        public final T next(int offset) {
            ((FSTStruct)this.current).___offset += (long)offset;
            this.hasNextElem = ((FSTStruct)this.current).___offset + (long)this.eSiz < this.maxPos;
            return this.current;
        }

        public int getElementSize() {
            return this.eSiz;
        }

        @Override
        public void remove() {
            throw new RuntimeException("unsupported operation");
        }
    }
}

