/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.StatPersisted;
import io.hops.hadoop.shaded.org.apache.zookeeper.metrics.MetricsUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.DeleteRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.SetDataRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SessionTracker;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumUtil;
import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.hamcrest.number.OrderingComparison;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessorMetricsTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessorMetricsTest.class);
    ZooKeeperServer zks;
    RequestProcessor nextProcessor;

    @Before
    public void setup() {
        System.setProperty("zookeeper.skipACL", "true");
        this.zks = Mockito.spy(new ZooKeeperServer());
        this.zks.sessionTracker = Mockito.mock(SessionTracker.class);
        ZKDatabase db = Mockito.mock(ZKDatabase.class);
        Mockito.when(this.zks.getZKDatabase()).thenReturn(db);
        DataNode node = new DataNode(new byte[1], null, Mockito.mock(StatPersisted.class));
        Mockito.when(db.getNode(ArgumentMatchers.anyString())).thenReturn(node);
        DataTree dataTree = Mockito.mock(DataTree.class);
        Mockito.when(db.getDataTree()).thenReturn(dataTree);
        HashSet<String> ephemerals = new HashSet<String>();
        ephemerals.add("/crystalmountain");
        ephemerals.add("/stevenspass");
        Mockito.when(db.getEphemerals(ArgumentMatchers.anyLong())).thenReturn(ephemerals);
        this.nextProcessor = Mockito.mock(RequestProcessor.class);
        ServerMetrics.getMetrics().resetAll();
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.skipACL");
    }

    private Request createRequest(Record record, int opCode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        record.serialize(boa, "request");
        baos.close();
        return new Request(null, 1L, 0, opCode, ByteBuffer.wrap(baos.toByteArray()), null);
    }

    private Request createRequest(String path, int opCode) throws IOException {
        Record record;
        switch (opCode) {
            case 5: {
                record = new SetDataRequest(path, new byte[0], -1);
                break;
            }
            case 2: {
                record = new DeleteRequest(path, -1);
                break;
            }
            default: {
                record = new DeleteRequest(path, -1);
            }
        }
        return this.createRequest(record, opCode);
    }

    private Request createRequest(long sessionId, int opCode) {
        return new Request(null, sessionId, 0, opCode, null, null);
    }

    @Test
    public void testPrepRequestProcessorMetrics() throws Exception {
        CountDownLatch threeRequests = new CountDownLatch(3);
        Mockito.doAnswer(invocationOnMock -> {
            threeRequests.countDown();
            return null;
        }).when(this.nextProcessor).processRequest((Request)ArgumentMatchers.any(Request.class));
        PrepRequestProcessor prepRequestProcessor = new PrepRequestProcessor(this.zks, this.nextProcessor);
        prepRequestProcessor.processRequest(this.createRequest("/foo", 5));
        prepRequestProcessor.processRequest(this.createRequest("/foo/bar", 2));
        prepRequestProcessor.processRequest(this.createRequest(2L, -11));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)3L, (Object)values.get("prep_processor_request_queued"));
        Thread.sleep(20L);
        prepRequestProcessor.start();
        threeRequests.await(500L, TimeUnit.MILLISECONDS);
        values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)3L, (Object)values.get("max_prep_processor_queue_size"));
        Assert.assertThat((Object)((Long)values.get("min_prep_processor_queue_time_ms")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(20L)));
        Assert.assertEquals((Object)3L, (Object)values.get("cnt_prep_processor_queue_time_ms"));
        Assert.assertEquals((Object)3L, (Object)values.get("cnt_prep_process_time"));
        Assert.assertThat((Object)((Long)values.get("max_prep_process_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)1L, (Object)values.get("cnt_close_session_prep_time"));
        Assert.assertThat((Object)((Long)values.get("max_close_session_prep_time")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)7L, (Object)values.get("outstanding_changes_queued"));
    }

    @Test
    public void testOutstandingChangesRemoved() throws Exception {
        QuorumUtil util = new QuorumUtil(1);
        util.startAll();
        ServerMetrics.getMetrics().resetAll();
        ZooKeeper zk = ClientBase.createZKClient(util.getConnString());
        zk.create("/test", new byte[50], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch created = new CountDownLatch(1);
        zk.exists("/test", new SimpleWatcher(created));
        created.await(200L, TimeUnit.MILLISECONDS);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertThat((Object)((Long)values.get("outstanding_changes_removed")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        util.shutdownAll();
    }

    private class SimpleWatcher
    implements Watcher {
        CountDownLatch created;

        public SimpleWatcher(CountDownLatch latch) {
            this.created = latch;
        }

        @Override
        public void process(WatchedEvent e) {
            this.created.countDown();
        }
    }
}

