/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.server.handler;

import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.org.eclipse.jetty.io.EndPoint;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.HttpChannel;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.Request;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.handler.HandlerWrapper;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.IncludeExclude;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.IncludeExcludeSet;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.InetAddressSet;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.component.DumpableCollection;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;

public class InetAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(InetAccessHandler.class);
    private final IncludeExcludeSet<String, InetAddress> _addrs = new IncludeExcludeSet(InetAddressSet.class);
    private final IncludeExclude<String> _names = new IncludeExclude();

    public void clear() {
        this._addrs.clear();
        this._names.clear();
    }

    public void include(String pattern) {
        this._addrs.include((Object)pattern);
    }

    public void include(String ... patterns) {
        this._addrs.include((Object[])patterns);
    }

    public void exclude(String pattern) {
        this._addrs.exclude((Object)pattern);
    }

    public void exclude(String ... patterns) {
        this._addrs.exclude((Object[])patterns);
    }

    public void includeConnector(String name) {
        this._names.include((Object)name);
    }

    public void excludeConnector(String name) {
        this._names.exclude((Object)name);
    }

    public void includeConnectors(String ... names) {
        this._names.include((Object[])names);
    }

    public void excludeConnectors(String ... names) {
        this._names.exclude((Object[])names);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        InetSocketAddress address;
        EndPoint endp;
        HttpChannel channel = baseRequest.getHttpChannel();
        if (channel != null && (endp = channel.getEndPoint()) != null && (address = endp.getRemoteAddress()) != null && !this.isAllowed(address.getAddress(), baseRequest, request)) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle(target, baseRequest, request, response);
    }

    protected boolean isAllowed(InetAddress addr, Request baseRequest, HttpServletRequest request) {
        String name = baseRequest.getHttpChannel().getConnector().getName();
        boolean filterAppliesToConnector = this._names.test((Object)name);
        boolean allowedByAddr = this._addrs.test((Object)addr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("name = {}/{} addr={}/{} appliesToConnector={} allowedByAddr={}", new Object[]{name, this._names, addr, this._addrs, filterAppliesToConnector, allowedByAddr});
        }
        if (!filterAppliesToConnector) {
            return true;
        }
        return allowedByAddr;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("included", (Collection)this._addrs.getIncluded()), new DumpableCollection("excluded", (Collection)this._addrs.getExcluded()), new DumpableCollection("includedConnector", (Collection)this._names.getIncluded()), new DumpableCollection("excludedConnector", (Collection)this._names.getExcluded())});
    }
}

