/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.utils;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.BaseFilter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EchoFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(EchoFilter.class);

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        Connection connection = ctx.getConnection();
        Object address = ctx.getAddress();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "EchoFilter. connection={0} dstAddress={1} message={2}", new Object[]{connection, address, message});
        }
        if (message instanceof Buffer) {
            ((Buffer)message).allowBufferDispose(true);
        }
        ctx.write(address, message, null);
        return ctx.getStopAction();
    }
}

