/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEException;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSSigner;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import io.hops.hadoop.shaded.com.nimbusds.jose.KeyLengthException;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.MACSigner;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.MACVerifier;
import io.hops.hadoop.shaded.com.nimbusds.jwt.JWTClaimsSet;
import io.hops.hadoop.shaded.com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Random;

public class MockJWTIssuer {
    private final byte[] sharedSecret;
    private final JWSSigner signer;
    private final JWSVerifier verifier;
    private final Random rand;

    public MockJWTIssuer(byte[] sharedSecret) throws KeyLengthException, JOSEException {
        this.sharedSecret = sharedSecret;
        this.signer = new MACSigner(sharedSecret);
        this.verifier = new MACVerifier(sharedSecret);
        this.rand = new Random();
    }

    public String generate(JWTClaimsSet.Builder claimsBuilder) throws JOSEException {
        claimsBuilder.issuer("MockJWTIssuer");
        claimsBuilder.claim("rand", (Object)this.rand.nextLong());
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsBuilder.build());
        signedJWT.sign(this.signer);
        return signedJWT.serialize();
    }

    public boolean verify(String token) throws ParseException, JOSEException {
        SignedJWT jwt = SignedJWT.parse((String)token);
        return jwt.verify(this.verifier);
    }
}

