/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.MultiResponse;
import io.hops.hadoop.shaded.org.apache.zookeeper.OpResult;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class MultiResponseTest
extends ZKTestCase {
    public void testRoundTrip() throws IOException {
        MultiResponse response = new MultiResponse();
        response.add(new OpResult.CheckResult());
        response.add(new OpResult.CreateResult("foo-bar"));
        response.add(new OpResult.DeleteResult());
        Stat s = new Stat();
        s.setCzxid(546L);
        response.add(new OpResult.SetDataResult(s));
        MultiResponse decodedResponse = this.codeDecode(response);
        Assert.assertEquals((Object)response, (Object)decodedResponse);
        Assert.assertEquals((long)response.hashCode(), (long)decodedResponse.hashCode());
    }

    @Test
    public void testEmptyRoundTrip() throws IOException {
        MultiResponse result = new MultiResponse();
        MultiResponse decodedResult = this.codeDecode(result);
        Assert.assertEquals((Object)result, (Object)decodedResult);
        Assert.assertEquals((long)result.hashCode(), (long)decodedResult.hashCode());
    }

    private MultiResponse codeDecode(MultiResponse request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        request.serialize(boa, "result");
        baos.close();
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        bb.rewind();
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(bb));
        MultiResponse decodedRequest = new MultiResponse();
        decodedRequest.deserialize(bia, "result");
        return decodedRequest;
    }
}

