/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXEnv {
    protected static final Logger LOG = LoggerFactory.getLogger(JMXEnv.class);
    private static JMXConnectorServer cs;
    private static JMXConnector cc;
    static Pattern standaloneRegEx;
    static Pattern instanceRegEx;
    static Pattern observerRegEx;
    static List<Pattern> beanPatterns;

    public static void setUp() throws IOException {
        MBeanServer mbs = MBeanRegistry.getInstance().getPlatformMBeanServer();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://127.0.0.1");
        cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
        cs.start();
        JMXServiceURL addr = cs.getAddress();
        LOG.info("connecting to addr {}", (Object)addr);
        cc = JMXConnectorFactory.connect(addr);
    }

    public static void tearDown() {
        try {
            if (cc != null) {
                cc.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected, ignoring", (Throwable)e);
        }
        cc = null;
        try {
            if (cs != null) {
                cs.stop();
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected, ignoring", (Throwable)e);
        }
        cs = null;
    }

    public static MBeanServerConnection conn() throws IOException {
        return cc.getMBeanServerConnection();
    }

    public static Set<ObjectName> ensureAll(String ... expectedNames) throws IOException, InterruptedException {
        Set<ObjectName> beans;
        HashSet<ObjectName> found;
        int nTry = 0;
        do {
            if (nTry++ > 0) {
                Thread.sleep(100L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("io.hops.hadoop.shaded.org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            found = new HashSet<ObjectName>();
            for (String name : expectedNames) {
                LOG.info("expect:{}", (Object)name);
                for (ObjectName bean : beans) {
                    if (!bean.toString().contains(name)) continue;
                    LOG.info("found:{} {}", (Object)name, (Object)bean);
                    found.add(bean);
                    break;
                }
                beans.removeAll(found);
            }
        } while (expectedNames.length != found.size() && nTry < 600);
        Assert.assertEquals((String)("expected " + Arrays.toString(expectedNames)), (long)expectedNames.length, (long)found.size());
        return beans;
    }

    public static Set<ObjectName> ensureOnly(String ... expectedNames) throws IOException, InterruptedException {
        LOG.info("ensureOnly:{}", (Object)Arrays.toString(expectedNames));
        Set<ObjectName> beans = JMXEnv.ensureAll(expectedNames);
        for (ObjectName bean : beans) {
            LOG.info("unexpected:{}", (Object)bean.toString());
        }
        Assert.assertEquals((long)0L, (long)beans.size());
        return beans;
    }

    public static void ensureNone(String ... expectedNames) throws IOException, InterruptedException {
        Set<ObjectName> beans;
        int nTry = 0;
        boolean foundUnexpected = false;
        String unexpectedName = "";
        block2: do {
            if (nTry++ > 0) {
                Thread.sleep(100L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("io.hops.hadoop.shaded.org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            foundUnexpected = false;
            for (String name : expectedNames) {
                for (ObjectName bean : beans) {
                    if (!bean.toString().contains(name)) continue;
                    LOG.info("didntexpect:{}", (Object)name);
                    foundUnexpected = true;
                    unexpectedName = name + " " + bean.toString();
                    break;
                }
                if (foundUnexpected) continue block2;
            }
        } while (foundUnexpected && nTry < 600);
        if (foundUnexpected) {
            LOG.info("List of all beans follows:");
            for (ObjectName bean : beans) {
                LOG.info("bean:{}", (Object)bean.toString());
            }
            Assert.fail((String)unexpectedName);
        }
    }

    public static void dump() throws IOException {
        Set<ObjectName> beans;
        LOG.info("JMXEnv.dump() follows");
        try {
            beans = JMXEnv.conn().queryNames(new ObjectName("io.hops.hadoop.shaded.org.apache.ZooKeeperService:*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        for (ObjectName bean : beans) {
            LOG.info("bean:{}", (Object)bean.toString());
        }
    }

    public static Set<ObjectName> ensureParent(String ... expectedNames) throws IOException, InterruptedException {
        Set<ObjectName> beans;
        LOG.info("ensureParent:{}", (Object)Arrays.toString(expectedNames));
        int nTry = 0;
        HashSet<ObjectName> found = new HashSet<ObjectName>();
        do {
            if (nTry++ > 0) {
                Thread.sleep(500L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("io.hops.hadoop.shaded.org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            found.clear();
            for (String name : expectedNames) {
                LOG.info("expect:{}", (Object)name);
                for (ObjectName bean : beans) {
                    if (!JMXEnv.compare(bean.toString(), name)) continue;
                    LOG.info("found:{} {}", (Object)name, (Object)bean);
                    found.add(bean);
                    break;
                }
                beans.removeAll(found);
            }
        } while (expectedNames.length != found.size() && nTry < 120);
        Assert.assertEquals((String)("expected " + Arrays.toString(expectedNames)), (long)expectedNames.length, (long)found.size());
        return beans;
    }

    public static Object ensureBeanAttribute(String expectedName, String expectedAttribute) throws Exception {
        String value = "";
        LOG.info("ensure bean:{}, attribute:{}", (Object)expectedName, (Object)expectedAttribute);
        int nTry = 0;
        do {
            Set<ObjectName> beans;
            if (nTry++ > 0) {
                Thread.sleep(500L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("io.hops.hadoop.shaded.org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            LOG.info("expect:{}", (Object)expectedName);
            for (ObjectName bean : beans) {
                if (!bean.toString().equals(expectedName)) continue;
                LOG.info("found:{} {}", (Object)expectedName, (Object)bean);
                return JMXEnv.conn().getAttribute(bean, expectedAttribute);
            }
        } while (nTry < 120);
        Assert.fail((String)("Failed to find bean:" + expectedName + ", attribute:" + expectedAttribute));
        return value;
    }

    private static boolean compare(String bean, String name) {
        String[] names = bean.split("=");
        return names.length > 0 && names[names.length - 1].contains(name);
    }

    public static List<ObjectName> getServerBeans() throws IOException {
        Set<ObjectName> beans;
        ArrayList<ObjectName> serverBeans = new ArrayList<ObjectName>();
        try {
            beans = JMXEnv.conn().queryNames(new ObjectName("io.hops.hadoop.shaded.org.apache.ZooKeeperService:*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        for (ObjectName bean : beans) {
            String name = bean.toString();
            LOG.info("bean:{}", (Object)name);
            for (Pattern pattern : beanPatterns) {
                if (!pattern.matcher(name).find()) continue;
                serverBeans.add(bean);
            }
        }
        return serverBeans;
    }

    public static ObjectName getServerBean() throws Exception {
        List<ObjectName> serverBeans = JMXEnv.getServerBeans();
        if (serverBeans.size() != 1) {
            throw new RuntimeException("Unable to find one and only one server bean");
        }
        return serverBeans.get(0);
    }

    static {
        standaloneRegEx = Pattern.compile("^org.apache.ZooKeeperService:name0=StandaloneServer_port-?\\d+$");
        instanceRegEx = Pattern.compile("^org.apache.ZooKeeperService:name0=ReplicatedServer_id(\\d+),name1=replica.(\\d+),name2=(Follower|Leader)$");
        observerRegEx = Pattern.compile("^org.apache.ZooKeeperService:name0=ReplicatedServer_id(-?\\d+),name1=replica.(-?\\d+),name2=(StandaloneServer_port-?\\d+)$");
        beanPatterns = Arrays.asList(standaloneRegEx, instanceRegEx, observerRegEx);
    }
}

