/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.admin.ZooKeeperAdmin;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigMisconfigTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigMisconfigTest.class);
    private QuorumUtil qu;
    private ZooKeeperAdmin zkAdmin;
    private static String errorMsg = "Reconfig should fail without configuring the super user's password on server side first.";

    @Before
    public void setup() throws InterruptedException {
        QuorumPeerConfig.setReconfigEnabled(true);
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        try {
            this.qu.startAll();
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to start quorum servers.");
        }
        this.instantiateZKAdmin();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.qu != null) {
                this.qu.tearDown();
            }
            if (this.zkAdmin != null) {
                this.zkAdmin.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testReconfigFailWithoutSuperuserPasswordConfiguredOnServer() throws InterruptedException {
        try {
            this.reconfigPort();
            Assert.fail((String)errorMsg);
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
        try {
            this.zkAdmin.addAuthInfo("digest", "super:".getBytes());
            this.reconfigPort();
            Assert.fail((String)errorMsg);
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    private void instantiateZKAdmin() throws InterruptedException {
        String cnxString;
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        try {
            cnxString = "127.0.0.1:" + this.qu.getPeer((int)1).peer.getClientPort();
            this.zkAdmin = new ZooKeeperAdmin(cnxString, ClientBase.CONNECTION_TIMEOUT, watcher);
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to create ZooKeeperAdmin handle.");
            return;
        }
        try {
            watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        }
        catch (InterruptedException | TimeoutException e) {
            Assert.fail((String)("ZooKeeper admin client can not connect to " + cnxString));
        }
    }

    private boolean reconfigPort() throws KeeperException, InterruptedException {
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderId = 1;
        while (this.qu.getPeer((int)leaderId).peer.leader == null) {
            ++leaderId;
        }
        int followerId = leaderId == 1 ? 2 : 1;
        joiningServers.add("server." + followerId + "=localhost:" + this.qu.getPeer((int)followerId).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)followerId).peer.getElectionAddress().getAllPorts().get(0) + ":participant;localhost:" + PortAssignment.unique());
        this.zkAdmin.reconfigure(joiningServers, null, null, -1L, new Stat());
        return true;
    }
}

