/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.metrics.MetricsUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperCriticalThreadMetricsTest
extends ZKTestCase {
    CountDownLatch processed;

    @Test
    public void testUnrecoverableErrorCountFromRequestProcessor() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        this.processed = new CountDownLatch(1);
        MyPrepRequestProcessor processor = new MyPrepRequestProcessor();
        processor.start();
        processor.processRequest(new Request(null, 1L, 1, 5, ByteBuffer.wrap(new byte[10]), null));
        this.processed.await();
        processor.shutdown();
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("unrecoverable_error_count"));
    }

    @Test
    public void testUnrecoverableErrorCount() {
        ServerMetrics.getMetrics().resetAll();
        ZooKeeperServer zks = new ZooKeeperServer();
        ZooKeeperCriticalThread thread = new ZooKeeperCriticalThread("test", zks.getZooKeeperServerListener());
        thread.handleException("test", new Exception());
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("unrecoverable_error_count"));
    }

    private class MyPrepRequestProcessor
    extends PrepRequestProcessor {
        public MyPrepRequestProcessor() {
            super(new ZooKeeperServer(), new MyRequestProcessor());
        }

        @Override
        public void run() {
            super.run();
            ZooKeeperCriticalThreadMetricsTest.this.processed.countDown();
        }
    }

    private class MyRequestProcessor
    implements RequestProcessor {
        private MyRequestProcessor() {
        }

        @Override
        public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
            throw new RequestProcessor.RequestProcessorException("test", new Exception());
        }

        @Override
        public void shutdown() {
        }
    }
}

