/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.metrics.MetricsUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.hamcrest.number.OrderingComparison;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncRequestProcessorMetricTest {
    ZooKeeperServer zks;
    RequestProcessor nextProcessor;
    CountDownLatch allRequestsFlushed;

    @Before
    public void setup() throws Exception {
        ZKDatabase db = Mockito.mock(ZKDatabase.class);
        Mockito.when(db.append((Request)ArgumentMatchers.any(Request.class))).thenReturn(true);
        Mockito.doAnswer(invocation -> {
            Thread.sleep(100L);
            return null;
        }).when(db).commit();
        this.zks = Mockito.mock(ZooKeeperServer.class);
        Mockito.when(this.zks.getZKDatabase()).thenReturn(db);
        this.nextProcessor = Mockito.mock(RequestProcessor.class);
        Mockito.doAnswer(invocationOnMock -> {
            this.allRequestsFlushed.countDown();
            return null;
        }).when(this.nextProcessor).processRequest((Request)ArgumentMatchers.any(Request.class));
    }

    private Request createRquest(long sessionId, int xid) {
        return new Request(null, sessionId, xid, 5, ByteBuffer.wrap(new byte[10]), null);
    }

    @Test
    public void testSyncProcessorMetrics() throws Exception {
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this.zks, this.nextProcessor);
        for (int i = 0; i < 500; ++i) {
            syncProcessor.processRequest(this.createRquest(1L, i));
        }
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)500L, (Object)values.get("sync_processor_request_queued"));
        this.allRequestsFlushed = new CountDownLatch(500);
        syncProcessor.start();
        this.allRequestsFlushed.await(5000L, TimeUnit.MILLISECONDS);
        values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)501L, (Object)values.get("cnt_sync_processor_queue_size"));
        Assert.assertEquals((Object)500L, (Object)values.get("max_sync_processor_queue_size"));
        Assert.assertEquals((Object)0L, (Object)values.get("min_sync_processor_queue_size"));
        Assert.assertEquals((Object)500L, (Object)values.get("cnt_sync_processor_queue_time_ms"));
        Assert.assertThat((Object)((Long)values.get("max_sync_processor_queue_time_ms")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)500L, (Object)values.get("cnt_sync_processor_queue_and_flush_time_ms"));
        Assert.assertThat((Object)((Long)values.get("max_sync_processor_queue_and_flush_time_ms")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)500L, (Object)values.get("cnt_sync_process_time"));
        Assert.assertThat((Object)((Long)values.get("max_sync_process_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)500L, (Object)values.get("max_sync_processor_batch_size"));
        Assert.assertEquals((Object)1L, (Object)values.get("cnt_sync_processor_queue_flush_time_ms"));
        Assert.assertThat((Object)((Long)values.get("max_sync_processor_queue_flush_time_ms")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(100L)));
        syncProcessor.shutdown();
    }
}

