/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class CreateTest
extends ClientBase {
    private ZooKeeper zk;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testCreate() throws IOException, KeeperException, InterruptedException {
        this.createNoStatVerifyResult("/foo");
        this.createNoStatVerifyResult("/foo/child");
    }

    @Test
    public void testCreateWithStat() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        Stat stat = this.createWithStatVerifyResult("/foo");
        Stat childStat = this.createWithStatVerifyResult("/foo/child");
        Assert.assertFalse((boolean)stat.equals(childStat));
    }

    @Test
    public void testCreateWithNullStat() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        Assert.assertNull((Object)this.zk.exists(name, false));
        Stat stat = null;
        String path = this.zk.create(name, name.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        Assert.assertNull(stat);
        Assert.assertNotNull((Object)this.zk.exists(name, false));
    }

    private void createNoStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assert.assertNull((String)"Node existed before created", (Object)this.zk.exists(newName, false));
        String path = this.zk.create(newName, newName.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)path, (Object)newName);
        Assert.assertNotNull((String)"Node was not created as expected", (Object)this.zk.exists(newName, false));
    }

    private Stat createWithStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assert.assertNull((String)"Node existed before created", (Object)this.zk.exists(newName, false));
        Stat stat = new Stat();
        String path = this.zk.create(newName, newName.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        Assert.assertEquals((Object)path, (Object)newName);
        this.validateCreateStat(stat, newName);
        Stat referenceStat = this.zk.exists(newName, false);
        Assert.assertNotNull((String)"Node was not created as expected", (Object)referenceStat);
        Assert.assertEquals((Object)referenceStat, (Object)stat);
        return stat;
    }

    private void validateCreateStat(Stat stat, String name) {
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assert.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assert.assertEquals((long)0L, (long)stat.getCversion());
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)stat.getAversion());
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assert.assertEquals((long)name.length(), (long)stat.getDataLength());
        Assert.assertEquals((long)0L, (long)stat.getNumChildren());
    }
}

