/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.DisconnectableZooKeeper;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private ServerCnxnFactory serverFactory;
    private ZooKeeperServer zs;
    private CountDownLatch startSignal;
    File tmpDir;
    private final int TICK_TIME = 3000;

    @Before
    public void setUp() throws Exception {
        if (this.tmpDir == null) {
            this.tmpDir = ClientBase.createTmpDir();
        }
        ClientBase.setupTestEnv();
        this.zs = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.serverFactory = ServerCnxnFactory.createFactory(PORT, -1);
        this.serverFactory.startup(this.zs);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
    }

    @After
    public void tearDown() throws Exception {
        this.serverFactory.shutdown();
        this.zs.shutdown();
        Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
    }

    private DisconnectableZooKeeper createClient() throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(ClientBase.CONNECTION_TIMEOUT, watcher);
    }

    private DisconnectableZooKeeper createClient(int timeout) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(timeout, watcher);
    }

    private DisconnectableZooKeeper createClient(int timeout, CountdownWatcher watcher) throws IOException, InterruptedException {
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(HOSTPORT, timeout, watcher);
        if (!watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSession() throws IOException, InterruptedException, KeeperException {
        DisconnectableZooKeeper zk = this.createClient();
        zk.create("/e", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        LOG.info("zk with session id 0x{} was destroyed!", (Object)Long.toHexString(zk.getSessionId()));
        zk.disconnect();
        Stat stat = new Stat();
        this.startSignal = new CountDownLatch(1);
        zk = new DisconnectableZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)new MyWatcher("testSession"), zk.getSessionId(), zk.getSessionPasswd());
        this.startSignal.await();
        LOG.info("zk with session id 0x{} was created!", (Object)Long.toHexString(zk.getSessionId()));
        zk.getData("/e", false, stat);
        LOG.info("After get data /e");
        zk.close();
        zk = this.createClient();
        Assert.assertEquals(null, (Object)zk.exists("/e", false));
        LOG.info("before close zk with session id 0x{}!", (Object)Long.toHexString(zk.getSessionId()));
        zk.close();
        try {
            zk.getData("/e", false, stat);
            Assert.fail((String)"Should have received a SessionExpiredException");
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
        AsyncCallback.DataCallback cb = new AsyncCallback.DataCallback(){
            String status = "not done";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processResult(int rc, String p, Object c, byte[] b, Stat s) {
                1 var6_6 = this;
                synchronized (var6_6) {
                    this.status = KeeperException.Code.get(rc).toString();
                    this.notify();
                }
            }

            public String toString() {
                return this.status;
            }
        };
        zk.getData("/e", false, cb, null);
        AsyncCallback.DataCallback dataCallback = cb;
        synchronized (dataCallback) {
            if (cb.toString().equals("not done")) {
                cb.wait(1000L);
            }
        }
        Assert.assertEquals((Object)KeeperException.Code.SESSIONEXPIRED.toString(), (Object)cb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Test
    public void testSessionMove() throws Exception {
        String[] hostPorts = HOSTPORT.split(",");
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[0], ClientBase.CONNECTION_TIMEOUT, new MyWatcher("0"));
        zk.create("/sessionMoveTest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        int i = 0;
        while (true) {
            if (i >= hostPorts.length * 2) {
                zk.close();
                return;
            }
            zk.dontReconnect();
            DisconnectableZooKeeper zknew = new DisconnectableZooKeeper(hostPorts[(i + 1) % hostPorts.length], ClientBase.CONNECTION_TIMEOUT, (Watcher)new MyWatcher(Integer.toString(i + 1)), zk.getSessionId(), zk.getSessionPasswd());
            final int[] result = new int[]{Integer.MAX_VALUE};
            zknew.sync("/", new AsyncCallback.VoidCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processResult(int rc, String path, Object ctx) {
                    int[] nArray = result;
                    synchronized (result) {
                        result[0] = rc;
                        result.notify();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                }
            }, null);
            int[] nArray = result;
            // MONITORENTER : result
            if (result[0] == Integer.MAX_VALUE) {
                result.wait(5000L);
            }
            // MONITOREXIT : nArray
            LOG.info("{} Sync returned {}", (Object)hostPorts[(i + 1) % hostPorts.length], (Object)result[0]);
            Assert.assertTrue((result[0] == KeeperException.Code.OK.intValue() ? 1 : 0) != 0);
            zknew.setData("/", new byte[1], -1);
            try {
                zk.setData("/", new byte[1], -1);
                Assert.fail((String)"Should have lost the connection");
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.info("Got connection loss exception as expected");
            }
            zk = zknew;
            ++i;
        }
    }

    @Test
    public void testSessionStateNoDupStateReporting() throws IOException, InterruptedException, KeeperException {
        int TIMEOUT = 3000;
        DupWatcher watcher = new DupWatcher();
        DisconnectableZooKeeper zk = this.createClient(3000, watcher);
        this.serverFactory.shutdown();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)watcher.states.size());
        zk.close();
    }

    @Test
    public void testSessionTimeoutAccess() throws Exception {
        DisconnectableZooKeeper zk = this.createClient(12000);
        Assert.assertEquals((long)12000L, (long)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(3000);
        Assert.assertEquals((long)6000L, (long)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(90000);
        Assert.assertEquals((long)60000L, (long)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
    }

    @Test
    public void testMinMaxSessionTimeout() throws Exception {
        int MINSESS = 20000;
        int MAXSESS = 240000;
        ZooKeeperServer zs = this.serverFactory.getZooKeeperServer();
        zs.setMinSessionTimeout(20000);
        zs.setMaxSessionTimeout(240000);
        int timeout = 120000;
        DisconnectableZooKeeper zk = this.createClient(timeout);
        Assert.assertEquals((long)timeout, (long)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(10000);
        Assert.assertEquals((long)20000L, (long)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(480000);
        Assert.assertEquals((long)240000L, (long)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
    }

    @Test
    public void testMaximumCnxnPerIP() throws Exception {
        int maxClientCnxnsPerIP = 3;
        this.serverFactory.setMaxClientCnxnsPerHost(3);
        ZooKeeper[] clients = new ZooKeeper[4];
        for (int i = 0; i < clients.length; ++i) {
            CountdownWatcher watcher = new CountdownWatcher();
            int timeout = 3000;
            clients[i] = new DisconnectableZooKeeper(HOSTPORT, timeout, watcher);
            boolean result = watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS);
            if (i >= 3) {
                Assert.assertFalse((boolean)result);
                continue;
            }
            Assert.assertTrue((boolean)result);
        }
    }

    private class DupWatcher
    extends CountdownWatcher {
        public List<WatchedEvent> states;

        private DupWatcher() {
            this.states = new LinkedList<WatchedEvent>();
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() == Watcher.Event.EventType.None) {
                this.states.add(event);
            }
        }
    }

    private class MyWatcher
    implements Watcher {
        private String name;

        public MyWatcher(String name) {
            this.name = name;
        }

        @Override
        public void process(WatchedEvent event) {
            LOG.info("{} event:{} {} {}", new Object[]{this.name, event.getState(), event.getType(), event.getPath()});
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected && SessionTest.this.startSignal != null && SessionTest.this.startSignal.getCount() > 0L) {
                SessionTest.this.startSignal.countDown();
            }
        }
    }

    private static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected = new CountDownLatch(1);

        private CountdownWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.clientConnected.countDown();
            }
        }
    }
}

