/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.StatPersisted;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DigestCalculator;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NodeHashMapImpl;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeHashMapImplTest
extends ZKTestCase {
    @Before
    public void setUp() {
        ZooKeeperServer.setDigestEnabled(true);
    }

    @After
    public void tearDown() {
        ZooKeeperServer.setDigestEnabled(false);
    }

    @Test
    public void testOperations() {
        NodeHashMapImpl nodes = new NodeHashMapImpl(new DigestCalculator());
        Assert.assertEquals((long)0L, (long)nodes.size());
        Assert.assertEquals((long)0L, (long)nodes.getDigest());
        String p1 = "p1";
        DataNode n1 = new DataNode(p1.getBytes(), 0L, new StatPersisted());
        nodes.put(p1, n1);
        Assert.assertEquals((Object)n1, (Object)nodes.get(p1));
        Assert.assertNotEquals((long)0L, (long)nodes.getDigest());
        Assert.assertEquals((long)1L, (long)nodes.size());
        String p2 = "p2";
        nodes.put(p2, new DataNode(p2.getBytes(), 0L, new StatPersisted()));
        Set<Map.Entry<String, DataNode>> entries = nodes.entrySet();
        Assert.assertEquals((long)2L, (long)entries.size());
        nodes.remove(p1);
        Assert.assertEquals((long)1L, (long)nodes.size());
        nodes.remove(p2);
        Assert.assertEquals((long)0L, (long)nodes.size());
        Assert.assertEquals((long)0L, (long)nodes.getDigest());
        String p3 = "p3";
        DataNode n3 = new DataNode(p3.getBytes(), 0L, new StatPersisted());
        nodes.put(p3, n3);
        long preChangeDigest = nodes.getDigest();
        Assert.assertNotEquals((long)0L, (long)preChangeDigest);
        nodes.preChange(p3, n3);
        Assert.assertEquals((long)0L, (long)nodes.getDigest());
        n3.stat.setMzxid(1L);
        n3.stat.setMtime(1L);
        n3.stat.setVersion(1);
        nodes.postChange(p3, n3);
        long postChangeDigest = nodes.getDigest();
        Assert.assertNotEquals((long)0L, (long)postChangeDigest);
        Assert.assertNotEquals((long)preChangeDigest, (long)postChangeDigest);
    }
}

