/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DigestCalculator;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.metric.SimpleCounter;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerMainTest;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDigestTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDigestTest.class);
    private ZooKeeper zk;
    private ZooKeeperServer server;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.serverFactory.getZooKeeperServer();
        this.zk = this.createClient();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.zk != null) {
            this.zk.close();
        }
    }

    @Override
    public void setupCustomizedEnv() {
        ZooKeeperServer.setDigestEnabled(true);
        System.setProperty("zookeeper.snapCount", "100");
    }

    @Override
    public void cleanUpCustomizedEnv() {
        ZooKeeperServer.setDigestEnabled(false);
        System.clearProperty("zookeeper.snapCount");
    }

    @Test
    public void testSnapshotDigest() throws Exception {
        this.server.takeSnapshot();
        this.reloadSnapshotAndCheckDigest();
        String pathPrefix = "/testSnapshotDigest";
        for (int i = 0; i < 1000; ++i) {
            String path = pathPrefix + i;
            this.zk.create(path, path.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        String firstNode = pathPrefix + 0;
        this.zk.setData(firstNode, "new_setdata".getBytes(), -1);
        this.zk.delete(firstNode, -1);
        ArrayList<Op> subTxns = new ArrayList<Op>();
        for (int i = 0; i < 3; ++i) {
            String path = pathPrefix + "-m" + i;
            subTxns.add(Op.create(path, path.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
        }
        this.zk.multi(subTxns);
        this.reloadSnapshotAndCheckDigest();
        this.server = this.serverFactory.getZooKeeperServer();
        this.server.takeSnapshot();
        this.reloadSnapshotAndCheckDigest();
    }

    @Test
    public void testDifferentDigestVersion() throws Exception {
        int currentVersion = new DigestCalculator().getDigestVersion();
        String path = "/testDifferentDigestVersion";
        this.zk.create(path, path.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.server.takeSnapshot();
        int newVersion = currentVersion + 1;
        DigestCalculator newVersionDigestCalculator = (DigestCalculator)((Object)Mockito.spy(DigestCalculator.class));
        Mockito.when(newVersionDigestCalculator.getDigestVersion()).thenReturn(newVersion);
        Assert.assertEquals((long)newVersion, (long)newVersionDigestCalculator.getDigestVersion());
        FileTxnSnapLog txnSnapLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        DataTree dataTree = Mockito.spy(new DataTree(newVersionDigestCalculator));
        Mockito.when(dataTree.getTreeDigest()).thenReturn(0L);
        txnSnapLog.restore(dataTree, new ConcurrentHashMap<Long, Integer>(), Mockito.mock(FileTxnSnapLog.PlayBackListener.class));
        Mockito.verify(dataTree, Mockito.never()).reportDigestMismatch(Mockito.anyLong());
    }

    @Test
    public void testBackwardCompatible() throws Exception {
        this.testCompatibleHelper(false, true);
        this.testCompatibleHelper(true, false);
    }

    private void testCompatibleHelper(Boolean enabledBefore, Boolean enabledAfter) throws Exception {
        ZooKeeperServer.setDigestEnabled(enabledBefore);
        this.reloadSnapshotAndCheckDigest();
        String path = "/testCompatible-" + enabledBefore + "-" + enabledAfter;
        this.zk.create(path, path.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.server.takeSnapshot();
        ZooKeeperServer.setDigestEnabled(enabledAfter);
        this.reloadSnapshotAndCheckDigest();
        Assert.assertEquals((Object)path, (Object)new String(this.zk.getData(path, false, null)));
    }

    private void reloadSnapshotAndCheckDigest() throws Exception {
        this.stopServer();
        QuorumPeerMainTest.waitForOne(this.zk, ZooKeeper.States.CONNECTING);
        ((SimpleCounter)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT).reset();
        this.startServer();
        QuorumPeerMainTest.waitForOne(this.zk, ZooKeeper.States.CONNECTED);
        this.server = this.serverFactory.getZooKeeperServer();
        Assert.assertEquals((long)0L, (long)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT.get());
        Assert.assertNull((Object)this.server.getZKDatabase().getDataTree().getDigestFromLoadedSnapshot());
    }
}

