/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.metric;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounter;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvgMinMaxPercentileCounterTest
extends ZKTestCase {
    private AvgMinMaxPercentileCounter testCounter;

    @Before
    public void initCounter() {
        this.testCounter = new AvgMinMaxPercentileCounter("test");
    }

    private void addDataPoints() {
        for (int i = 0; i < 1000; ++i) {
            this.testCounter.add(i);
        }
    }

    @Test
    public void testReset() {
        this.addDataPoints();
        this.testCounter.reset();
        Map<String, Object> values = this.testCounter.values();
        Assert.assertEquals((String)"There should be 9 values in the set", (long)9L, (long)values.size());
        Assert.assertEquals((String)"should avg=0", (Object)0.0, (Object)values.get("avg_test"));
        Assert.assertEquals((String)"should have min=0", (Object)0L, (Object)values.get("min_test"));
        Assert.assertEquals((String)"should have max=0", (Object)0L, (Object)values.get("max_test"));
        Assert.assertEquals((String)"should have cnt=0", (Object)0L, (Object)values.get("cnt_test"));
        Assert.assertEquals((String)"should have sum=0", (Object)0L, (Object)values.get("sum_test"));
        Assert.assertEquals((String)"should have p50=0", (Object)0L, (Object)values.get("p50_test"));
        Assert.assertEquals((String)"should have p95=0", (Object)0L, (Object)values.get("p95_test"));
        Assert.assertEquals((String)"should have p99=0", (Object)0L, (Object)values.get("p99_test"));
        Assert.assertEquals((String)"should have p999=0", (Object)0L, (Object)values.get("p999_test"));
    }

    @Test
    public void testValues() {
        this.addDataPoints();
        Map<String, Object> values = this.testCounter.values();
        Assert.assertEquals((String)"There should be 9 values in the set", (long)9L, (long)values.size());
        Assert.assertEquals((String)"should avg=499.5", (Object)499.5, (Object)values.get("avg_test"));
        Assert.assertEquals((String)"should have min=0", (Object)0L, (Object)values.get("min_test"));
        Assert.assertEquals((String)"should have max=999", (Object)999L, (Object)values.get("max_test"));
        Assert.assertEquals((String)"should have cnt=1000", (Object)1000L, (Object)values.get("cnt_test"));
        Assert.assertEquals((String)"should have sum=999*500", (Object)499500L, (Object)values.get("sum_test"));
        Assert.assertEquals((String)"should have p50=500", (Object)500L, (Object)values.get("p50_test"));
        Assert.assertEquals((String)"should have p95=950", (Object)950L, (Object)values.get("p95_test"));
        Assert.assertEquals((String)"should have p99=990", (Object)990L, (Object)values.get("p99_test"));
        Assert.assertEquals((String)"should have p999=999", (Object)999L, (Object)values.get("p999_test"));
    }
}

