/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.zookeeper.data.Id;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.AuthUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AuthUtilTest {
    @BeforeClass
    public static void beforeClassSetUp() {
        ProviderRegistry.reset();
        System.setProperty("zookeeper.authProvider.sasl", "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.authProvider.x509", "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.X509AuthenticationProvider");
    }

    @AfterClass
    public static void afterClassTearDown() {
        System.clearProperty("zookeeper.authProvider.sasl");
        System.clearProperty("zookeeper.authProvider.x509");
    }

    @Test
    public void testGetUserFromAllAuthenticationScheme() {
        String user = "zkUser";
        Id id = new Id("digest", user + ":password");
        String result = AuthUtil.getUser(id);
        Assert.assertEquals((Object)user, (Object)result);
        String principal = "zkCli/hadoop.hadoop.com";
        id = new Id("sasl", principal);
        Assert.assertEquals((Object)principal, (Object)AuthUtil.getUser(id));
        String ip = "192.168.1.2";
        id = new Id("ip", ip);
        Assert.assertEquals((Object)ip, (Object)AuthUtil.getUser(id));
        String certificate = "CN=host-192.168.1.2,OU=OrganizationUnit,O=Organization,L=Location,ST=State,C=IN";
        id = new Id("x509", certificate);
        Assert.assertEquals((Object)certificate, (Object)AuthUtil.getUser(id));
    }

    @Test
    public void testGetUserShouldReturnNullIfAuthenticationNotConfigured() {
        Id id = new Id("invalid Authentication Scheme", "user");
        String result = AuthUtil.getUser(id);
        Assert.assertNull((Object)result);
    }
}

