/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.RestoreCommittedLogTest;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptiedSnapshotRecoveryTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreCommittedLogTest.class);
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int N_TRANSACTIONS = 150;
    private static final int SNAP_COUNT = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(boolean leaveEmptyFile, boolean trustEmptySnap) throws Exception {
        File tmpSnapDir = ClientBase.createTmpDir();
        File tmpLogDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpSnapDir, tmpLogDir, 3000);
        SyncRequestProcessor.setSnapCount(100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        try (ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, this);){
            for (int i = 0; i < 150; ++i) {
                zk.create("/node-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        f.shutdown();
        zks.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        zks = new ZooKeeperServer(tmpSnapDir, tmpLogDir, 3000);
        zks.startdata();
        long zxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        LOG.info("After clean restart, zxid = {}", (Object)zxid);
        Assert.assertTrue((String)"zxid > 0", (zxid > 0L ? 1 : 0) != 0);
        zks.shutdown();
        FileTxnSnapLog txnLogFactory = zks.getTxnLogFactory();
        List<File> snapshots = txnLogFactory.findNRecentSnapshots(10);
        Assert.assertTrue((String)"We have a snapshot to corrupt", (snapshots.size() > 0 ? 1 : 0) != 0);
        for (File file : snapshots) {
            if (leaveEmptyFile) {
                new PrintWriter(file).close();
                continue;
            }
            file.delete();
        }
        if (trustEmptySnap) {
            System.setProperty("zookeeper.snapshot.trust.empty", "true");
        }
        zks = new ZooKeeperServer(tmpSnapDir, tmpLogDir, 3000);
        try {
            zks.startdata();
            long currentZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
            if (!trustEmptySnap) {
                Assert.fail((String)"Should have gotten exception for corrupted database");
            }
            Assert.assertEquals((String)"zxid mismatch after restoring database", (long)currentZxid, (long)zxid);
        }
        catch (IOException e) {
            if (trustEmptySnap) {
                Assert.fail((String)"Should not get exception for empty database");
            }
        }
        finally {
            if (trustEmptySnap) {
                System.clearProperty("zookeeper.snapshot.trust.empty");
            }
        }
        zks.shutdown();
    }

    @Test
    public void testRestoreWithEmptySnapFiles() throws Exception {
        this.runTest(true, false);
    }

    @Test
    public void testRestoreWithNoSnapFiles() throws Exception {
        this.runTest(false, false);
    }

    @Test
    public void testRestoreWithTrustedEmptySnapFiles() throws Exception {
        this.runTest(false, true);
    }

    @Override
    public void process(WatchedEvent event) {
    }
}

