/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain;

import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.DefaultFilterChain;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.Filter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChain;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class FilterChainBuilder {
    protected final DefaultFilterChain patternFilterChain = new DefaultFilterChain();

    private FilterChainBuilder() {
    }

    public static FilterChainBuilder stateless() {
        return new StatelessFilterChainBuilder();
    }

    public static FilterChainBuilder stateful() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public abstract FilterChain build();

    public FilterChainBuilder add(Filter filter) {
        return this.addLast(filter);
    }

    public FilterChainBuilder addFirst(Filter filter) {
        this.patternFilterChain.add(0, filter);
        return this;
    }

    public FilterChainBuilder addLast(Filter filter) {
        this.patternFilterChain.add(filter);
        return this;
    }

    public FilterChainBuilder add(int index, Filter filter) {
        this.patternFilterChain.add(index, filter);
        return this;
    }

    public FilterChainBuilder set(int index, Filter filter) {
        this.patternFilterChain.set(index, filter);
        return this;
    }

    public FilterChainBuilder remove(int index) {
        this.patternFilterChain.remove(index);
        return this;
    }

    public FilterChainBuilder remove(Filter filter) {
        this.patternFilterChain.remove(filter);
        return this;
    }

    public FilterChainBuilder addAll(Filter[] array) {
        this.patternFilterChain.addAll(this.patternFilterChain.size(), (Collection<? extends Filter>)Arrays.asList(array));
        return this;
    }

    public FilterChainBuilder addAll(int filterIndex, Filter[] array) {
        this.patternFilterChain.addAll(filterIndex, (Collection<? extends Filter>)Arrays.asList(array));
        return this;
    }

    public FilterChainBuilder addAll(List<Filter> list) {
        return this.addAll(this.patternFilterChain.size(), list);
    }

    public FilterChainBuilder addAll(int filterIndex, List<Filter> list) {
        this.patternFilterChain.addAll(filterIndex, (Collection<? extends Filter>)list);
        return this;
    }

    public int indexOf(Filter filter) {
        return this.patternFilterChain.indexOf(filter);
    }

    public int indexOfType(Class<? extends Filter> filterType) {
        return this.patternFilterChain.indexOfType(filterType);
    }

    public static class StatelessFilterChainBuilder
    extends FilterChainBuilder {
        @Override
        public FilterChain build() {
            return this.patternFilterChain;
        }
    }
}

