/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import io.hops.hadoop.shaded.com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.resolvingcache.Cache;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class InMemoryCache
extends Cache {
    private ConcurrentLinkedHashMap<String, Long> pathCache;
    private ConcurrentLinkedHashMap<Long, INodeIdentifier> inodeIdCache;
    private int CACHE_MAXIMUM_SIZE;

    @Override
    protected void setConfiguration(Configuration conf) throws IOException {
        this.CACHE_MAXIMUM_SIZE = conf.getInt("dfs.resolvingcache.inmemory.maxsize", 100000);
        super.setConfiguration(conf);
    }

    @Override
    protected void startInternal() throws IOException {
        this.pathCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.CACHE_MAXIMUM_SIZE).build();
        this.inodeIdCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.CACHE_MAXIMUM_SIZE).build();
    }

    @Override
    protected void stopInternal() {
    }

    @Override
    protected void setInternal(String path, List<INode> inodes) {
        for (INode inode : inodes) {
            if (inode == null) continue;
            this.pathCache.put((Object)inode.nameParentKey(), (Object)inode.getId());
            this.inodeIdCache.put((Object)inode.getId(), (Object)new INodeIdentifier(Long.valueOf(inode.getId()), Long.valueOf(inode.getParentId()), inode.getLocalName(), inode.getPartitionId()));
        }
    }

    @Override
    protected void setInternal(INode inode) {
        if (inode != null) {
            this.inodeIdCache.put((Object)inode.getId(), (Object)new INodeIdentifier(Long.valueOf(inode.getId()), Long.valueOf(inode.getParentId()), inode.getLocalName(), inode.getPartitionId()));
        }
    }

    @Override
    protected long[] getInternal(String path) throws IOException {
        String cmp;
        Long inodeId;
        int index;
        String[] pathComponents = INode.getPathNames(path);
        long[] inodeIds = new long[pathComponents.length];
        long parentId = 0L;
        for (index = 0; index < pathComponents.length && (inodeId = (Long)this.pathCache.get((Object)INode.nameParentKey(parentId, cmp = pathComponents[index]))) != null; ++index) {
            parentId = inodeId;
            inodeIds[index] = inodeId;
        }
        if (index <= 1) {
            return null;
        }
        return Arrays.copyOf(inodeIds, index);
    }

    @Override
    protected INodeIdentifier getInternal(long inodeId) throws IOException {
        return (INodeIdentifier)this.inodeIdCache.get((Object)inodeId);
    }

    @Override
    protected void deleteInternal(String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deleteInternal(INode inode) {
        this.pathCache.remove((Object)inode.nameParentKey());
        this.inodeIdCache.remove((Object)inode.getId());
    }

    @Override
    protected void deleteInternal(INodeIdentifier inode) {
        this.inodeIdCache.remove((Object)inode.getInodeId());
    }

    @Override
    protected void flushInternal() {
        this.pathCache.clear();
        this.inodeIdCache.clear();
    }

    @Override
    protected int getRoundTrips(String path) {
        return INode.getPathNames(path).length;
    }

    @Override
    protected int getRoundTrips(List<INode> inodes) {
        return inodes.size();
    }
}

