/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FSLimitException
extends QuotaExceededException {
    protected static final long serialVersionUID = 1L;

    protected FSLimitException() {
    }

    protected FSLimitException(String msg) {
        super(msg);
    }

    protected FSLimitException(long quota, long count) {
        super(quota, count);
    }

    public static final class MaxDirectoryItemsExceededException
    extends FSLimitException {
        protected static final long serialVersionUID = 1L;

        protected MaxDirectoryItemsExceededException() {
        }

        protected MaxDirectoryItemsExceededException(String msg) {
            super(msg);
        }

        public MaxDirectoryItemsExceededException(long quota, long count) {
            super(quota, count);
        }

        public String getMessage() {
            return "The directory item limit of " + this.pathName + " is exceeded: limit=" + this.quota + " items=" + this.count;
        }
    }

    public static final class PathComponentTooLongException
    extends FSLimitException {
        protected static final long serialVersionUID = 1L;
        private String childName;

        protected PathComponentTooLongException() {
        }

        protected PathComponentTooLongException(String msg) {
            super(msg);
        }

        public PathComponentTooLongException(long quota, long count, String parentPath, String childName) {
            super(quota, count);
            this.setPathName(parentPath);
            this.childName = childName;
        }

        String getParentPath() {
            return this.pathName;
        }

        public String getMessage() {
            return "The maximum path component name limit of " + this.childName + " in directory " + this.getParentPath() + " is exceeded: limit=" + this.quota + " length=" + this.count;
        }
    }
}

