/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.SignedBytes;
import io.hops.erasure_coding.ErasureCodingManager;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.transaction.EntityManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeAclHelper;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.ChunkedArrayList;
import org.apache.hadoop.hdfs.util.LongBitFormat;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class INode
implements Comparable<byte[]>,
LightWeightGSet.LinkedElement {
    public static final List<INode> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    protected byte blockStoragePolicyID;
    protected boolean inTree = false;
    protected long parentId = 0L;
    public static int RANDOM_PARTITIONING_MAX_LEVEL = 1;
    protected boolean subtreeLocked;
    protected long subtreeLockOwner;
    public static final long ROOT_INODE_ID = 1L;
    private byte numUserXAttrs;
    private byte numSysXAttrs;
    private int numAces;
    protected INode parent = null;
    protected LightWeightGSet.LinkedElement next = null;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public static void checkId(long requestId, INode inode) throws FileNotFoundException {
        if (requestId != 0L && requestId != inode.getId()) {
            throw new FileNotFoundException("ID mismatch. Request id and saved id: " + requestId + " , " + inode.getId());
        }
    }

    INode(INode parent) {
        this.parent = parent;
    }

    public abstract long getId();

    public AclFeature getAclFeature() throws TransactionContextException, StorageException, AclException {
        return INodeAclHelper.getAclFeature(this);
    }

    public void addAclFeature(AclFeature aclFeature) throws TransactionContextException, StorageException, AclException {
        INodeAclHelper.addAclFeature(this, aclFeature);
    }

    public void removeAclFeature() throws TransactionContextException, StorageException {
        INodeAclHelper.removeAclFeature(this);
    }

    abstract XAttrFeature getXAttrFeature();

    abstract void addXAttrFeature(XAttrFeature var1);

    abstract void removeXAttrFeature();

    public final boolean isRoot() {
        return this.getLocalNameBytes() != null && this.getLocalNameBytes().length == 0 && this.getId() == 1L;
    }

    public abstract PermissionStatus getPermissionStatus() throws IOException;

    public abstract String getUserName() throws IOException;

    public abstract int getUserID();

    public abstract String getGroupName() throws IOException;

    public abstract int getGroupID();

    public abstract FsPermission getFsPermission();

    protected abstract short getFsPermissionShort();

    public boolean isFile() {
        return false;
    }

    public INodeFile asFile() throws StorageException, TransactionContextException {
        throw new IllegalStateException("Current inode is not a file: " + this.toDetailString());
    }

    public boolean isDirectory() {
        return false;
    }

    public INodeDirectory asDirectory() throws StorageException, TransactionContextException {
        throw new IllegalStateException("Current inode is not a directory: " + this.toDetailString());
    }

    public boolean isSymlink() {
        return false;
    }

    public INodeSymlink asSymlink() throws StorageException, TransactionContextException {
        throw new IllegalStateException("Current inode is not a symlink: " + this.toDetailString());
    }

    public abstract void destroyAndCollectBlocks(BlockStoragePolicySuite var1, BlocksMapUpdateInfo var2, List<INode> var3) throws StorageException, TransactionContextException;

    public final ContentSummary computeContentSummary(BlockStoragePolicySuite bsps) throws StorageException, TransactionContextException {
        return this.computeAndConvertContentSummary(new ContentSummaryComputationContext(bsps));
    }

    public final ContentSummary computeAndConvertContentSummary(ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        ContentCounts counts = this.computeContentSummary(summary).getCounts();
        QuotaCounts q = this.getQuotaCounts();
        return new ContentSummary.Builder().length(counts.getLength()).fileCount(counts.getFileCount() + counts.getSymlinkCount()).directoryCount(counts.getDirectoryCount()).quota(q.getNameSpace()).spaceConsumed(counts.getStoragespace()).spaceQuota(q.getStorageSpace()).typeConsumed(counts.getTypeSpaces()).typeQuota(q.getTypeSpaces().asArray()).build();
    }

    public abstract ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext var1) throws StorageException, TransactionContextException;

    public void addSpaceConsumed(QuotaCounts counts, boolean verify) throws QuotaExceededException, StorageException, TransactionContextException {
        this.addSpaceConsumed2Parent(counts, verify);
    }

    void addSpaceConsumed2Parent(QuotaCounts counts, boolean verify) throws QuotaExceededException, StorageException, TransactionContextException {
        if (this.parent != null) {
            this.parent.addSpaceConsumed(counts, verify);
        }
    }

    public QuotaCounts getQuotaCounts() throws StorageException, TransactionContextException {
        return new QuotaCounts.Builder().nameSpace(-1L).storageSpace(-1L).typeSpaces(-1L).build();
    }

    public final boolean isQuotaSet() throws StorageException, TransactionContextException {
        QuotaCounts qc = this.getQuotaCounts();
        return qc.anyNsSsCountGreaterOrEqual(0L) || qc.anyTypeSpaceCountGreaterOrEqual(0L);
    }

    public final QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps) throws TransactionContextException, StorageException {
        byte storagePolicyId = this.isSymlink() ? (byte)0 : this.getStoragePolicyID();
        return this.computeQuotaUsage(bsps, storagePolicyId, new QuotaCounts.Builder().build());
    }

    abstract QuotaCounts computeQuotaUsage(BlockStoragePolicySuite var1, byte var2, QuotaCounts var3) throws StorageException, TransactionContextException;

    public final QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, QuotaCounts counts) throws TransactionContextException, StorageException {
        byte storagePolicyId = this.isSymlink() ? (byte)0 : this.getStoragePolicyID();
        return this.computeQuotaUsage(bsps, storagePolicyId, counts);
    }

    public String getLocalName() {
        byte[] name = this.getLocalNameBytes();
        return name == null ? null : DFSUtil.bytes2String(name);
    }

    String getLocalParentDir() throws StorageException, TransactionContextException {
        INode inode = this.isRoot() ? this : this.getParent();
        String parentDir = "";
        if (inode != null) {
            parentDir = inode.getFullPathName();
        }
        return parentDir != null ? parentDir : "";
    }

    abstract byte[] getLocalNameBytes();

    public abstract void setLocalNameNoPersistance(String var1);

    public abstract void setLocalNameNoPersistance(byte[] var1);

    public String getFullPathName() throws StorageException, TransactionContextException {
        return FSDirectory.getFullPathName(this);
    }

    public String toString() {
        try {
            return "\"" + this.getFullPathName() + "\":" + this.getUserName() + ":" + this.getGroupName() + ":" + (this.isDirectory() ? "d" : "-") + this.getFsPermission();
        }
        catch (IOException ex) {
            Logger.getLogger(INode.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @VisibleForTesting
    public final String getObjectString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    @VisibleForTesting
    public final String getParentString() throws StorageException, TransactionContextException {
        INodeDirectory parentDir = this.getParent();
        if (parentDir != null) {
            return "parentDir=" + parentDir.getLocalName() + "/";
        }
        return "parent=null";
    }

    @VisibleForTesting
    public String toDetailString() throws StorageException, TransactionContextException {
        INodeDirectory p = this.getParent();
        return this.toStringWithObjectType() + ", parent=" + (p == null ? null : p.toStringWithObjectType());
    }

    @VisibleForTesting
    public String toStringWithObjectType() {
        return this.toString() + "(" + this.getObjectString() + ")";
    }

    INodeDirectory getParent() throws StorageException, TransactionContextException {
        if (this.isRoot()) {
            return null;
        }
        if (this.parent == null && this.getParentId() != 0L) {
            this.parent = (INode)EntityManager.find((FinderType)Finder.ByINodeIdFTIS, (Object[])new Object[]{this.getParentId()});
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.asDirectory();
    }

    public abstract long getModificationTime();

    public abstract void updateModificationTime(long var1) throws QuotaExceededException, StorageException, TransactionContextException;

    public abstract void setModificationTimeNoPersistance(long var1);

    public abstract long getAccessTime();

    public abstract void setAccessTimeNoPersistance(long var1);

    public byte getStoragePolicyID() throws TransactionContextException, StorageException {
        byte id = this.getLocalStoragePolicyID();
        if (id == 0) {
            return this.getParent() != null ? this.getParent().getStoragePolicyID() : id;
        }
        return id;
    }

    public byte getLocalStoragePolicyID() {
        return this.blockStoragePolicyID;
    }

    public boolean isUnderConstruction() {
        return false;
    }

    public byte getStoragePolicyIDForQuota(byte parentStoragePolicyId) {
        byte localId = this.isSymlink() ? (byte)0 : this.getLocalStoragePolicyID();
        return localId != 0 ? localId : parentStoragePolicyId;
    }

    public static byte[][] getPathComponents(String path) {
        return INode.getPathComponents(INode.getPathNames(path));
    }

    public static byte[][] getPathComponents(String[] strings) {
        if (strings.length == 0) {
            return new byte[][]{null};
        }
        byte[][] bytes = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            bytes[i] = DFSUtil.string2Bytes(strings[i]);
        }
        return bytes;
    }

    public static String[] getPathNames(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new AssertionError((Object)"Absolute path required");
        }
        return StringUtils.split((String)path, (char)'/');
    }

    static String constructPath(byte[][] components, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append(DFSUtil.bytes2String(components[i]));
            if (i >= end - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    boolean removeNode() throws IOException {
        if (this.parent == null) {
            return false;
        }
        ((INodeDirectory)this.parent).removeChild(this);
        this.parent = null;
        return true;
    }

    @Override
    public final int compareTo(byte[] bytes) {
        byte[] name = this.getLocalNameBytes();
        byte[] left = name == null ? EMPTY_BYTES : name;
        byte[] right = bytes == null ? EMPTY_BYTES : bytes;
        return SignedBytes.lexicographicalComparator().compare(left, right);
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof INode)) {
            return false;
        }
        return this.getId() == ((INode)that).getId();
    }

    public final int hashCode() {
        int id = Long.hashCode(this.getId());
        return id ^ id >>> 32;
    }

    public void setParent(INodeDirectory p) throws StorageException, TransactionContextException {
        this.setParentNoPersistance(p);
        this.save();
    }

    public void setParentNoPersistance(INodeDirectory p) {
        this.parent = p;
        this.parentId = p.getId();
    }

    public void setParentIdNoPersistance(long pid) {
        this.parentId = pid;
    }

    public long getParentId() {
        return this.parentId;
    }

    public static String nameParentKey(long parentId, String name) {
        return parentId + name;
    }

    public String nameParentKey() {
        return INode.nameParentKey(this.parentId, this.getLocalName());
    }

    protected abstract void setUser(String var1) throws IOException;

    public abstract void setUserID(int var1) throws IOException;

    public abstract void setUserIDNoPersistence(int var1);

    protected abstract void setGroup(String var1) throws IOException;

    public abstract void setGroupID(int var1) throws IOException;

    public abstract void setGroupIDNoPersistence(int var1);

    abstract void setPermission(FsPermission var1) throws StorageException, TransactionContextException;

    public void setLocalName(String name) throws StorageException, TransactionContextException {
        this.setLocalNameNoPersistance(name);
        this.save();
    }

    public abstract void setLocalName(byte[] var1) throws StorageException, TransactionContextException;

    public abstract void setModificationTime(long var1) throws StorageException, TransactionContextException;

    public abstract void setAccessTime(long var1) throws TransactionContextException, StorageException;

    public void setStoragePolicyID(byte blockStoragePolicyID) throws TransactionContextException, StorageException {
        this.setBlockStoragePolicyIDNoPersistance(blockStoragePolicyID);
        this.save();
    }

    public void setBlockStoragePolicyIDNoPersistance(byte blockStoragePolicyID) throws TransactionContextException, StorageException {
        this.blockStoragePolicyID = blockStoragePolicyID;
    }

    abstract void setModificationTimeForce(long var1) throws StorageException, TransactionContextException;

    public int getNumAces() {
        return this.numAces;
    }

    public void setNumAces(int numAces) throws TransactionContextException, StorageException {
        this.setNumAcesNoPersistence(numAces);
        this.save();
    }

    public void setNumAcesNoPersistence(int numAces) {
        this.numAces = numAces;
    }

    public void inTree() {
        this.inTree = true;
    }

    public boolean isInTree() {
        return this.inTree;
    }

    protected void save() throws StorageException, TransactionContextException {
        this.save(this);
    }

    protected void save(INode node) throws StorageException, TransactionContextException {
        EntityManager.update((Object)node);
    }

    protected void remove() throws IOException {
        this.remove(this);
    }

    protected void remove(INode node) throws IOException {
        EntityManager.remove((Object)node);
        if (node instanceof INodeDirectory && ((INodeDirectory)node).isWithQuota()) {
            DirectoryWithQuotaFeature q = ((INodeDirectory)node).getDirectoryWithQuotaFeature();
            q.remove();
            ((INodeDirectory)node).removeFeature(q);
        }
        this.cleanParity(node);
        if (node.hasXAttrs() && node.getXAttrFeature() != null) {
            node.getXAttrFeature().remove(node.getNumUserXAttrs() + node.getNumSysXAttrs());
            node.removeXAttrFeature();
        }
    }

    private void cleanParity(INode node) throws StorageException, TransactionContextException {
        if (ErasureCodingManager.isEnabled()) {
            if (node instanceof INodeFile && ((INodeFile)node).isFileStoredInDB()) {
                return;
            }
            EncodingStatus status = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{node.getId()});
            if (status != null) {
                status.setStatus(EncodingStatus.Status.DELETED);
                EntityManager.update((Object)status);
            }
        }
    }

    public boolean isSTOLocked() {
        return this.subtreeLocked;
    }

    public void setSubtreeLocked(boolean subtreeLocked) {
        this.subtreeLocked = subtreeLocked;
    }

    public long getSTOLockOwner() {
        return this.subtreeLockOwner;
    }

    public void setSubtreeLockOwner(long subtreeLockOwner) {
        this.subtreeLockOwner = subtreeLockOwner;
    }

    public void lockSubtree(long subtreeLockOwner) {
        this.setSubtreeLocked(true);
        this.setSubtreeLockOwner(subtreeLockOwner);
    }

    public void unlockSubtree() {
        this.setSubtreeLocked(false);
    }

    public abstract void logMetadataEvent(INodeMetadataLogEntry.Operation var1) throws StorageException, TransactionContextException;

    public abstract void logProvenanceEvent(long var1, FileProvenanceEntry.Operation var3) throws IOException;

    public abstract void logProvenanceEvent(long var1, FileProvenanceEntry.Operation var3, XAttr var4) throws IOException;

    boolean isPathMetaEnabled() throws TransactionContextException, StorageException {
        return this.getMetaEnabledParent() != null;
    }

    INodeDirectory getMetaEnabledParent() throws TransactionContextException, StorageException {
        INodeDirectory dir = this.getParent();
        while (!this.isRoot() && !dir.isRoot()) {
            if (dir.isMetaEnabled()) {
                return dir;
            }
            dir = dir.getParent();
        }
        return null;
    }

    public abstract Long getPartitionId();

    public abstract void setPartitionIdNoPersistance(long var1);

    public abstract void setPartitionId(Long var1) throws TransactionContextException, StorageException;

    public void calculateAndSetPartitionIdNoPersistance(long parentId, String name, short depth) {
        this.setPartitionIdNoPersistance(INode.calculatePartitionId(parentId, name, depth));
    }

    public void calculateAndSetPartitionId(long parentId, String name, short depth) throws TransactionContextException, StorageException {
        this.setPartitionIdNoPersistance(INode.calculatePartitionId(parentId, name, depth));
        this.save();
    }

    public static long calculatePartitionId(long parentId, String name, short depth) {
        if (INode.isTreeLevelRandomPartitioned(depth)) {
            return INode.partitionIdHashFunction(parentId, name, depth);
        }
        return parentId;
    }

    private static long partitionIdHashFunction(long parentId, String name, short depth) {
        if (depth == 0) {
            return 0L;
        }
        return (name + parentId).hashCode();
    }

    public static boolean isTreeLevelRandomPartitioned(short depth) {
        return depth <= RANDOM_PARTITIONING_MAX_LEVEL;
    }

    public abstract long getHeader();

    public abstract void setHeaderNoPersistance(long var1);

    public void setHasBlocks(boolean hasBlocks) throws TransactionContextException, StorageException {
        this.setHasBlocksNoPersistance(hasBlocks);
        this.save();
    }

    @VisibleForTesting
    public abstract void setHasBlocksNoPersistance(boolean var1) throws TransactionContextException, StorageException;

    public abstract boolean hasBlocks();

    public short myDepth() throws TransactionContextException, StorageException {
        if (this.getId() == 1L) {
            return 0;
        }
        INode parentInode = (INode)EntityManager.find((FinderType)Finder.ByINodeIdFTIS, (Object[])new Object[]{this.getParentId()});
        return (short)(parentInode.myDepth() + 1);
    }

    public boolean equalsIdentifier(INodeIdentifier iNodeIdentifier) {
        if (iNodeIdentifier == null) {
            return false;
        }
        if (this.getId() != iNodeIdentifier.getInodeId().longValue()) {
            return false;
        }
        if (this.getParentId() != iNodeIdentifier.getPid().longValue()) {
            return false;
        }
        if (iNodeIdentifier.getPartitionId() == null) {
            return false;
        }
        if (!this.getPartitionId().equals(iNodeIdentifier.getPartitionId())) {
            return false;
        }
        return this.getLocalName().equals(iNodeIdentifier.getName());
    }

    public abstract int getLogicalTime();

    public abstract void setLogicalTimeNoPersistance(Integer var1);

    public abstract int incrementLogicalTime();

    @VisibleForTesting
    public StringBuffer dumpTreeRecursively() throws StorageException, TransactionContextException {
        StringWriter out = new StringWriter();
        this.dumpTreeRecursively(new PrintWriter((Writer)out, true), new StringBuilder());
        return out.getBuffer();
    }

    @VisibleForTesting
    public final void dumpTreeRecursively(PrintStream out) throws StorageException, TransactionContextException {
        out.println(this.dumpTreeRecursively().toString());
    }

    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix) throws StorageException, TransactionContextException {
        out.print(prefix);
        out.print(" ");
        out.print(this.getLocalName());
        out.print("   (");
        String s = super.toString();
        out.print(s.substring(s.lastIndexOf(this.getClass().getSimpleName())));
        out.println(")");
    }

    public abstract INode cloneInode() throws IOException;

    public void setNext(LightWeightGSet.LinkedElement next) {
        this.next = next;
    }

    public LightWeightGSet.LinkedElement getNext() {
        return this.next;
    }

    public byte getNumUserXAttrs() {
        return this.numUserXAttrs;
    }

    public void incrementUserXAttrs() throws TransactionContextException, StorageException {
        this.numUserXAttrs = (byte)(this.numUserXAttrs + 1);
        this.save();
    }

    public void decrementUserXAttrs() throws TransactionContextException, StorageException {
        this.numUserXAttrs = (byte)(this.numUserXAttrs - 1);
        this.save();
    }

    public void setNumUserXAttrsNoPersistence(byte numUserXAttrs) {
        this.numUserXAttrs = numUserXAttrs;
    }

    public byte getNumSysXAttrs() {
        return this.numSysXAttrs;
    }

    public void incrementSysXAttrs() throws TransactionContextException, StorageException {
        this.numSysXAttrs = (byte)(this.numSysXAttrs + 1);
        this.save();
    }

    public void decrementSysXAttrs() throws TransactionContextException, StorageException {
        this.numSysXAttrs = (byte)(this.numSysXAttrs - 1);
        this.save();
    }

    public void setNumSysXAttrsNoPersistence(byte numSysXAttrs) {
        this.numSysXAttrs = numSysXAttrs;
    }

    public boolean hasXAttrs() {
        return this.getNumUserXAttrs() > 0 || this.getNumSysXAttrs() > 0;
    }

    public static interface Feature {
    }

    public static class BlocksMapUpdateInfo {
        private List<Block> toDeleteList;

        public BlocksMapUpdateInfo(List<Block> toDeleteList) {
            this.toDeleteList = toDeleteList == null ? new ChunkedArrayList() : toDeleteList;
        }

        public BlocksMapUpdateInfo() {
            this.toDeleteList = new ArrayList<Block>();
        }

        public List<Block> getToDeleteList() {
            return this.toDeleteList;
        }

        public void addDeleteBlock(Block toDelete) {
            assert (toDelete != null) : "toDelete is null";
            this.toDeleteList.add(toDelete);
        }

        public void removeDeleteBlock(Block block) {
            assert (block != null) : "block is null";
            this.toDeleteList.remove(block);
        }

        public void clear() {
            this.toDeleteList.clear();
        }
    }

    static enum HeaderFormat {
        PREFERRED_BLOCK_SIZE(null, 48, 1L),
        REPLICATION(HeaderFormat.PREFERRED_BLOCK_SIZE.BITS, 8, 1L),
        HAS_BLOCKS(HeaderFormat.REPLICATION.BITS, 8, 0L);

        public final LongBitFormat BITS;

        private HeaderFormat(LongBitFormat previous, int length, long min) {
            this.BITS = new LongBitFormat(this.name(), previous, length, min);
        }

        static short getReplication(long header) {
            return (short)HeaderFormat.REPLICATION.BITS.retrieve(header);
        }

        public static long getPreferredBlockSize(long header) {
            return HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.retrieve(header);
        }

        static long toLong(long preferredBlockSize, short replication) {
            long h = 0L;
            if (preferredBlockSize == 0L) {
                preferredBlockSize = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.getMin();
            }
            h = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.combine(preferredBlockSize, h);
            h = HeaderFormat.REPLICATION.BITS.combine(replication, h);
            return h;
        }

        public static boolean hasBlocks(long header) {
            long val = HeaderFormat.HAS_BLOCKS.BITS.retrieve(header);
            if (val == 1L) {
                return true;
            }
            if (val == 0L) {
                return false;
            }
            throw new IllegalStateException("Flags in the inode header are messed up");
        }
    }

    public static enum Order implements Comparator<INode>
    {
        ByName{

            @Override
            public int compare(INode o1, INode o2) {
                return o1.compareTo(o2.getLocalNameBytes());
            }
        };


        @Override
        public abstract int compare(INode var1, INode var2);
    }

    public static enum Finder implements FinderType<INode>
    {
        ByINodeIdFTIS,
        ByParentIdFTIS,
        ByParentIdAndPartitionId,
        ByNameParentIdAndPartitionId,
        ByNamesParentIdsAndPartitionIdsCheckLocal,
        ByNamesParentIdsAndPartitionIds;


        public Class getType() {
            return INode.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByINodeIdFTIS: {
                    return FinderType.Annotation.IndexScan;
                }
                case ByParentIdFTIS: {
                    return FinderType.Annotation.IndexScan;
                }
                case ByParentIdAndPartitionId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByNameParentIdAndPartitionId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByNamesParentIdsAndPartitionIds: {
                    return FinderType.Annotation.Batched;
                }
                case ByNamesParentIdsAndPartitionIdsCheckLocal: {
                    return FinderType.Annotation.Batched;
                }
            }
            throw new IllegalStateException();
        }
    }
}

