/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.google.inject.internal;

import io.hops.hadoop.shaded.com.google.inject.Guice;
import io.hops.hadoop.shaded.com.google.inject.internal.AbstractProcessor;
import io.hops.hadoop.shaded.com.google.inject.internal.Errors;
import io.hops.hadoop.shaded.com.google.inject.spi.Message;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MessageProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(Guice.class.getName());

    MessageProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(Message message) {
        if (message.getCause() != null) {
            String rootMessage = MessageProcessor.getRootMessage(message.getCause());
            String string = String.valueOf(rootMessage);
            logger.log(Level.INFO, string.length() != 0 ? "An exception was caught and reported. Message: ".concat(string) : new String("An exception was caught and reported. Message: "), message.getCause());
        }
        this.errors.addMessage(message);
        return true;
    }

    public static String getRootMessage(Throwable t) {
        Throwable cause = t.getCause();
        return cause == null ? t.toString() : MessageProcessor.getRootMessage(cause);
    }
}

