/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.hops.hadoop.shaded.com.google.inject.Binding;
import io.hops.hadoop.shaded.com.google.inject.Key;
import io.hops.hadoop.shaded.com.google.inject.OutOfScopeException;
import io.hops.hadoop.shaded.com.google.inject.Provider;
import io.hops.hadoop.shaded.com.google.inject.Scope;
import io.hops.hadoop.shaded.com.google.inject.Scopes;
import io.hops.hadoop.shaded.com.google.inject.servlet.ContinuingHttpServletRequest;
import io.hops.hadoop.shaded.com.google.inject.servlet.GuiceFilter;
import io.hops.hadoop.shaded.com.google.inject.servlet.RequestParameters;
import io.hops.hadoop.shaded.com.google.inject.servlet.RequestScoped;
import io.hops.hadoop.shaded.com.google.inject.servlet.ScopingException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.javax.servlet.http.HttpSession;
import java.util.Map;
import java.util.concurrent.Callable;

public class ServletScopes {
    private static final ThreadLocal<Context> requestScopeContext = new ThreadLocal();
    public static final Scope REQUEST = new Scope(){

        @Override
        public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
            return new Provider<T>(){
                private final ImmutableSet<Key<?>> REQUEST_CONTEXT_KEYS = ImmutableSet.of(Key.get(HttpServletRequest.class), Key.get(HttpServletResponse.class), (Object)new Key<Map<String, String[]>>(RequestParameters.class){});

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    Context context;
                    if (null == GuiceFilter.localContext.get() && null != (context = (Context)requestScopeContext.get())) {
                        Object t = context.map.get(key);
                        if (NullObject.INSTANCE == t) {
                            return null;
                        }
                        if (t == null && !Scopes.isCircularProxy(t = creator.get())) {
                            context.map.put(key, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                    HttpServletRequest request = GuiceFilter.getOriginalRequest(key);
                    if (this.REQUEST_CONTEXT_KEYS.contains((Object)key)) {
                        return creator.get();
                    }
                    String name = key.toString();
                    HttpServletRequest httpServletRequest = request;
                    synchronized (httpServletRequest) {
                        Object obj = request.getAttribute(name);
                        if (NullObject.INSTANCE == obj) {
                            return null;
                        }
                        Object t = obj;
                        if (t == null && !Scopes.isCircularProxy(t = creator.get())) {
                            request.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, REQUEST);
                }
            };
        }

        @Override
        public String toString() {
            return "ServletScopes.REQUEST";
        }
    };
    public static final Scope SESSION = new Scope(){

        @Override
        public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    HttpSession session;
                    HttpSession httpSession = session = GuiceFilter.getRequest(key).getSession();
                    synchronized (httpSession) {
                        Object obj = session.getAttribute(name);
                        if (NullObject.INSTANCE == obj) {
                            return null;
                        }
                        Object t = obj;
                        if (t == null && !Scopes.isCircularProxy(t = creator.get())) {
                            session.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, SESSION);
                }
            };
        }

        @Override
        public String toString() {
            return "ServletScopes.SESSION";
        }
    };

    private ServletScopes() {
    }

    public static <T> Callable<T> continueRequest(final Callable<T> callable, Map<Key<?>, Object> seedMap) {
        Preconditions.checkArgument((null != seedMap ? 1 : 0) != 0, (Object)"Seed map cannot be null, try passing in Collections.emptyMap() instead.");
        final ContinuingHttpServletRequest continuingRequest = new ContinuingHttpServletRequest(GuiceFilter.getRequest(Key.get(HttpServletRequest.class)));
        for (Map.Entry<Key<?>, Object> entry : seedMap.entrySet()) {
            Object value = ServletScopes.validateAndCanonicalizeValue(entry.getKey(), entry.getValue());
            continuingRequest.setAttribute(entry.getKey().toString(), value);
        }
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                ServletScopes.checkScopingState(null == GuiceFilter.localContext.get(), "Cannot continue request in the same thread as a HTTP request!");
                return new GuiceFilter.Context((HttpServletRequest)continuingRequest, (HttpServletRequest)continuingRequest, null).call(callable);
            }
        };
    }

    public static <T> Callable<T> transferRequest(Callable<T> callable) {
        return GuiceFilter.localContext.get() != null ? ServletScopes.transferHttpRequest(callable) : ServletScopes.transferNonHttpRequest(callable);
    }

    private static <T> Callable<T> transferHttpRequest(final Callable<T> callable) {
        final GuiceFilter.Context context = GuiceFilter.localContext.get();
        if (context == null) {
            throw new OutOfScopeException("Not in a request scope");
        }
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return context.call(callable);
            }
        };
    }

    private static <T> Callable<T> transferNonHttpRequest(final Callable<T> callable) {
        final Context context = requestScopeContext.get();
        if (context == null) {
            throw new OutOfScopeException("Not in a request scope");
        }
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return context.call(callable);
            }
        };
    }

    public static boolean isRequestScoped(Binding<?> binding) {
        return Scopes.isScoped(binding, REQUEST, RequestScoped.class);
    }

    public static <T> Callable<T> scopeRequest(final Callable<T> callable, Map<Key<?>, Object> seedMap) {
        Preconditions.checkArgument((null != seedMap ? 1 : 0) != 0, (Object)"Seed map cannot be null, try passing in Collections.emptyMap() instead.");
        final Context context = new Context();
        Map validatedAndCanonicalizedMap = Maps.transformEntries(seedMap, (Maps.EntryTransformer)new Maps.EntryTransformer<Key<?>, Object, Object>(){

            public Object transformEntry(Key<?> key, Object value) {
                return ServletScopes.validateAndCanonicalizeValue(key, value);
            }
        });
        context.map.putAll(validatedAndCanonicalizedMap);
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                ServletScopes.checkScopingState(null == GuiceFilter.localContext.get(), "An HTTP request is already in progress, cannot scope a new request in this thread.");
                ServletScopes.checkScopingState(null == requestScopeContext.get(), "A request scope is already in progress, cannot scope a new request in this thread.");
                return context.call(callable);
            }
        };
    }

    private static Object validateAndCanonicalizeValue(Key<?> key, Object object) {
        if (object == null || object == NullObject.INSTANCE) {
            return NullObject.INSTANCE;
        }
        if (!key.getTypeLiteral().getRawType().isInstance(object)) {
            String string = String.valueOf(String.valueOf(object));
            String string2 = String.valueOf(String.valueOf(object.getClass().getName()));
            String string3 = String.valueOf(String.valueOf(key));
            throw new IllegalArgumentException(new StringBuilder(46 + string.length() + string2.length() + string3.length()).append("Value[").append(string).append("] of type[").append(string2).append("] is not compatible with key[").append(string3).append("]").toString());
        }
        return object;
    }

    private static void checkScopingState(boolean condition, String msg) {
        if (!condition) {
            throw new ScopingException(msg);
        }
    }

    private static class Context {
        final Map<Key, Object> map = Maps.newHashMap();

        private Context() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized <T> T call(Callable<T> callable) throws Exception {
            Context previous = (Context)requestScopeContext.get();
            requestScopeContext.set(this);
            try {
                T t = callable.call();
                return t;
            }
            finally {
                requestScopeContext.set(previous);
            }
        }
    }

    static enum NullObject {
        INSTANCE;

    }
}

