/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.OutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.ACL;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Id;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ReferenceCountedACLCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceCountedACLCacheTest {
    @Test
    public void testSameACLGivesSameID() {
        List<ACL> testACL = this.createACL("myid");
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        Long aclId = cache.convertAcls(testACL);
        List<ACL> testACL2 = this.createACL("myid");
        Assert.assertEquals((Object)aclId, (Object)cache.convertAcls(testACL2));
    }

    @Test
    public void testWhetherOrderingMatters() {
        ArrayList<ACL> testACL = new ArrayList<ACL>();
        testACL.add(new ACL(1, new Id("scheme", "ro")));
        testACL.add(new ACL(2, new Id("scheme", "rw")));
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        Long aclId = cache.convertAcls(testACL);
        ArrayList<ACL> testACL2 = new ArrayList<ACL>();
        testACL2.add(new ACL(2, new Id("scheme", "rw")));
        testACL2.add(new ACL(1, new Id("scheme", "ro")));
        Assert.assertFalse((boolean)aclId.equals(cache.convertAcls(testACL2)));
    }

    @Test
    public void testBidirectionality() {
        List<ACL> testACL = this.createACL("myid");
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        Long aclId = cache.convertAcls(testACL);
        Assert.assertEquals(testACL, cache.convertLong(aclId));
    }

    @Test
    public void testCacheSize() {
        List<ACL> testACL = this.createACL("myid");
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        Long aclId = cache.convertAcls(testACL);
        Assert.assertEquals((long)1L, (long)cache.size());
        List<ACL> testACL2 = this.createACL("myid");
        Assert.assertEquals((Object)aclId, (Object)cache.convertAcls(testACL2));
        Assert.assertEquals((long)1L, (long)cache.size());
        List<ACL> testACL3 = this.createACL("differentId");
        Long aclId3 = cache.convertAcls(testACL3);
        Assert.assertFalse((boolean)aclId3.equals(aclId));
        Assert.assertEquals((long)2L, (long)cache.size());
    }

    @Test
    public void testAddThenRemove() {
        List<ACL> testACL = this.createACL("myid");
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        Long aclId = cache.convertAcls(testACL);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.removeUsage(aclId);
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testMultipleAddsAndRemove() {
        List<ACL> testACL = this.createACL("myid");
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        Long aclId = cache.convertAcls(testACL);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.convertAcls(testACL);
        Assert.assertEquals((long)1L, (long)cache.size());
        List<ACL> testACL2 = this.createACL("anotherId");
        cache.convertAcls(testACL2);
        cache.removeUsage(aclId);
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.removeUsage(aclId);
        Assert.assertEquals((long)1L, (long)cache.size());
        Long newId = cache.convertAcls(testACL);
        Assert.assertFalse((boolean)aclId.equals(newId));
    }

    @Test
    public void testAddUsage() {
        List<ACL> testACL = this.createACL("myid");
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        Long aclId = cache.convertAcls(testACL);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.addUsage(aclId);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.removeUsage(aclId);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.removeUsage(aclId);
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testAddNonExistentUsage() {
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        cache.addUsage(1L);
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testSerializeDeserialize() throws IOException {
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        List<ACL> acl1 = this.createACL("one");
        List<ACL> acl2 = this.createACL("two");
        List<ACL> acl3 = this.createACL("three");
        List<ACL> acl4 = this.createACL("four");
        List<ACL> acl5 = this.createACL("five");
        Long aclId1 = this.convertACLsNTimes(cache, acl1, 1);
        Long aclId2 = this.convertACLsNTimes(cache, acl2, 2);
        Long aclId3 = this.convertACLsNTimes(cache, acl3, 3);
        Long aclId4 = this.convertACLsNTimes(cache, acl4, 4);
        Long aclId5 = this.convertACLsNTimes(cache, acl5, 5);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive archive = BinaryOutputArchive.getArchive(baos);
        cache.serialize(archive);
        BinaryInputArchive inArchive = BinaryInputArchive.getArchive(new ByteArrayInputStream(baos.toByteArray()));
        ReferenceCountedACLCache deserializedCache = new ReferenceCountedACLCache();
        deserializedCache.deserialize(inArchive);
        this.callAddUsageNTimes(deserializedCache, aclId1, 1);
        this.callAddUsageNTimes(deserializedCache, aclId2, 2);
        this.callAddUsageNTimes(deserializedCache, aclId3, 3);
        this.callAddUsageNTimes(deserializedCache, aclId4, 4);
        this.callAddUsageNTimes(deserializedCache, aclId5, 5);
        this.assertCachesEqual(cache, deserializedCache);
    }

    @Test
    public void testNPEInDeserialize() throws IOException {
        ReferenceCountedACLCache serializeCache = new ReferenceCountedACLCache(){

            @Override
            public synchronized void serialize(OutputArchive oa) throws IOException {
                oa.writeInt(1, "map");
                oa.writeLong(1L, "long");
                oa.startVector(null, "acls");
                oa.endVector(null, "acls");
            }
        };
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive archive = BinaryOutputArchive.getArchive(baos);
        serializeCache.serialize(archive);
        BinaryInputArchive inArchive = BinaryInputArchive.getArchive(new ByteArrayInputStream(baos.toByteArray()));
        ReferenceCountedACLCache deserializedCache = new ReferenceCountedACLCache();
        try {
            deserializedCache.deserialize(inArchive);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"should not throw NPE while do deserialized");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void assertCachesEqual(ReferenceCountedACLCache expected, ReferenceCountedACLCache actual) {
        Assert.assertEquals((long)expected.aclIndex, (long)actual.aclIndex);
        Assert.assertEquals(expected.aclKeyMap, actual.aclKeyMap);
        Assert.assertEquals(expected.longKeyMap, actual.longKeyMap);
        Assert.assertEquals(expected.referenceCounter, actual.referenceCounter);
    }

    @Test
    public void testPurgeUnused() throws IOException {
        ReferenceCountedACLCache cache = new ReferenceCountedACLCache();
        List<ACL> acl1 = this.createACL("one");
        List<ACL> acl2 = this.createACL("two");
        List<ACL> acl3 = this.createACL("three");
        List<ACL> acl4 = this.createACL("four");
        List<ACL> acl5 = this.createACL("five");
        Long aclId1 = this.convertACLsNTimes(cache, acl1, 1);
        Long aclId2 = this.convertACLsNTimes(cache, acl2, 2);
        Long aclId3 = this.convertACLsNTimes(cache, acl3, 3);
        Long aclId4 = this.convertACLsNTimes(cache, acl4, 4);
        Long aclId5 = this.convertACLsNTimes(cache, acl5, 5);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive archive = BinaryOutputArchive.getArchive(baos);
        cache.serialize(archive);
        BinaryInputArchive inArchive = BinaryInputArchive.getArchive(new ByteArrayInputStream(baos.toByteArray()));
        ReferenceCountedACLCache deserializedCache = new ReferenceCountedACLCache();
        deserializedCache.deserialize(inArchive);
        this.callAddUsageNTimes(deserializedCache, aclId1, 1);
        this.callAddUsageNTimes(deserializedCache, aclId2, 2);
        deserializedCache.purgeUnused();
        Assert.assertEquals((long)2L, (long)deserializedCache.size());
        Assert.assertEquals((Object)aclId1, (Object)deserializedCache.convertAcls(acl1));
        Assert.assertEquals((Object)aclId2, (Object)deserializedCache.convertAcls(acl2));
        Assert.assertFalse((boolean)acl3.equals(deserializedCache.convertAcls(acl3)));
        Assert.assertFalse((boolean)acl4.equals(deserializedCache.convertAcls(acl4)));
        Assert.assertFalse((boolean)acl5.equals(deserializedCache.convertAcls(acl5)));
    }

    private void callAddUsageNTimes(ReferenceCountedACLCache deserializedCache, Long aclId, int num) {
        for (int i = 0; i < num; ++i) {
            deserializedCache.addUsage(aclId);
        }
    }

    private Long convertACLsNTimes(ReferenceCountedACLCache cache, List<ACL> acl, int num) {
        if (num <= 0) {
            return -1L;
        }
        for (int i = 0; i < num - 1; ++i) {
            cache.convertAcls(acl);
        }
        return cache.convertAcls(acl);
    }

    private List<ACL> createACL(String id) {
        ArrayList<ACL> acl1 = new ArrayList<ACL>();
        acl1.add(new ACL(16, new Id("scheme", id)));
        return acl1;
    }
}

