/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test.system;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.system.Instance;

public class SimpleClient
implements Instance,
Watcher,
AsyncCallback.DataCallback,
AsyncCallback.StringCallback,
AsyncCallback.StatCallback {
    private static final long serialVersionUID = 1L;
    String hostPort;
    ZooKeeper zk;
    transient int index;
    transient String myPath;
    byte[] data;
    boolean createdEphemeral;
    Instance.Reporter r;

    @Override
    public void configure(String params) {
        String[] parts = params.split(" ");
        this.hostPort = parts[1];
        this.index = Integer.parseInt(parts[0]);
        this.myPath = "/simpleCase/" + this.index;
    }

    @Override
    public void start() {
        try {
            this.zk = new ZooKeeper(this.hostPort, 15000, this);
            this.zk.getData("/simpleCase", true, (AsyncCallback.DataCallback)this, null);
            if (null != this.r) {
                this.r.report("Client " + this.index + " connecting to " + this.hostPort);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            if (this.zk != null) {
                this.zk.close();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(WatchedEvent event) {
        if (event.getPath() != null && event.getPath().equals("/simpleCase")) {
            this.zk.getData("/simpleCase", true, (AsyncCallback.DataCallback)this, null);
        }
    }

    @Override
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        if (rc != 0) {
            this.zk.getData("/simpleCase", true, (AsyncCallback.DataCallback)this, null);
        } else {
            this.data = data;
            String content = new String(data);
            if (content.equals("die")) {
                this.stop();
                return;
            }
            if (!this.createdEphemeral) {
                this.zk.create(this.myPath, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, this, null);
                this.createdEphemeral = true;
            } else {
                this.zk.setData(this.myPath, data, -1, this, null);
            }
        }
    }

    @Override
    public void processResult(int rc, String path, Object ctx, String name) {
        if (rc != 0) {
            this.zk.create(this.myPath, this.data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, this, null);
        }
    }

    @Override
    public void processResult(int rc, String path, Object ctx, Stat stat) {
        if (rc != 0) {
            this.zk.setData(this.myPath, this.data, -1, this, null);
        }
    }

    public String toString() {
        return SimpleClient.class.getName() + "[" + this.index + "] using " + this.hostPort;
    }

    @Override
    public void setReporter(Instance.Reporter r) {
        this.r = r;
    }
}

