/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.codehaus.jettison.mapped;

import io.hops.hadoop.shaded.org.codehaus.jettison.AbstractXMLStreamReader;
import io.hops.hadoop.shaded.org.codehaus.jettison.Node;
import io.hops.hadoop.shaded.org.codehaus.jettison.json.JSONArray;
import io.hops.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import io.hops.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import io.hops.hadoop.shaded.org.codehaus.jettison.mapped.MappedNamespaceConvention;
import io.hops.hadoop.shaded.org.codehaus.jettison.util.FastStack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;

public class MappedXMLStreamReader
extends AbstractXMLStreamReader {
    private FastStack nodes;
    private String currentValue;
    private MappedNamespaceConvention convention;
    private String valueKey = "$";

    public MappedXMLStreamReader(JSONObject obj) throws JSONException, XMLStreamException {
        this(obj, new MappedNamespaceConvention());
    }

    public MappedXMLStreamReader(JSONObject obj, MappedNamespaceConvention con) throws JSONException, XMLStreamException {
        String rootName = (String)obj.keys().next();
        this.convention = con;
        this.nodes = new FastStack();
        Object top = obj.get(rootName);
        if (top instanceof JSONObject) {
            this.node = new Node(rootName, (JSONObject)top, this.convention);
        } else if (top instanceof JSONArray && (((JSONArray)top).length() != 1 || !((JSONArray)top).get(0).equals(""))) {
            this.node = new Node(rootName, ((JSONArray)top).getJSONObject(0), this.convention);
        } else {
            this.node = new Node(rootName, this.convention);
            this.convention.processAttributesAndNamespaces(this.node, obj);
            this.currentValue = top.toString();
        }
        this.nodes.push(this.node);
        this.event = 7;
    }

    public int next() throws XMLStreamException {
        if (this.event == 7) {
            this.event = 1;
        } else if (this.event == 4) {
            this.event = 2;
            this.node = (Node)this.nodes.pop();
            this.currentValue = null;
        } else if (this.event == 1 || this.event == 2) {
            if (this.event == 2 && this.nodes.size() > 0) {
                this.node = (Node)this.nodes.peek();
            }
            if (this.currentValue != null) {
                this.event = 4;
            } else if (this.node.getKeys() != null && this.node.getKeys().hasNext() || this.node.getArray() != null) {
                this.processElement();
            } else if (this.nodes.size() > 0) {
                this.event = 2;
                this.node = (Node)this.nodes.pop();
            } else {
                this.event = 8;
            }
        }
        if (this.nodes.size() > 0) {
            Node next = (Node)this.nodes.peek();
            if (this.event == 1 && next.getName().getLocalPart().equals(this.valueKey)) {
                this.event = 4;
                this.node = (Node)this.nodes.pop();
            }
        }
        return this.event;
    }

    private void processElement() throws XMLStreamException {
        try {
            Object newObj = null;
            String nextKey = null;
            if (this.node.getArray() != null) {
                int index = this.node.getArrayIndex();
                if (index >= this.node.getArray().length()) {
                    this.nodes.pop();
                    this.node = (Node)this.nodes.peek();
                    if (this.node == null) {
                        this.event = 8;
                        return;
                    }
                    if (this.node.getKeys() != null && this.node.getKeys().hasNext() || this.node.getArray() != null) {
                        this.processElement();
                    } else {
                        this.event = 2;
                        this.node = (Node)this.nodes.pop();
                    }
                    return;
                }
                newObj = this.node.getArray().get(index++);
                nextKey = this.node.getName().getLocalPart();
                this.node.setArrayIndex(index);
            } else {
                nextKey = (String)this.node.getKeys().next();
                newObj = this.node.getObject().get(nextKey);
            }
            if (newObj instanceof String) {
                this.node = new Node(nextKey, this.convention);
                this.nodes.push(this.node);
                this.currentValue = (String)newObj;
                this.event = 1;
                return;
            }
            if (newObj instanceof JSONArray) {
                JSONArray array = (JSONArray)newObj;
                this.node = new Node(nextKey, this.convention);
                this.node.setArray(array);
                this.node.setArrayIndex(0);
                this.nodes.push(this.node);
                this.processElement();
                return;
            }
            if (newObj instanceof JSONObject) {
                this.node = new Node(nextKey, (JSONObject)newObj, this.convention);
                this.nodes.push(this.node);
                this.event = 1;
                return;
            }
            this.node = new Node(nextKey, this.convention);
            this.nodes.push(this.node);
            this.currentValue = newObj.toString();
            this.event = 1;
            return;
        }
        catch (JSONException e) {
            throw new XMLStreamException(e);
        }
    }

    public void close() throws XMLStreamException {
    }

    public String getElementText() throws XMLStreamException {
        this.event = 4;
        return this.currentValue;
    }

    public NamespaceContext getNamespaceContext() {
        return null;
    }

    public String getText() {
        return this.currentValue;
    }

    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        return 0;
    }

    public void setValueKey(String valueKey) {
        this.valueKey = valueKey;
    }
}

